<?php
/**
 * Курсы валют с сайта finance.ua
 */

//Какие валюты получать
$aNeedCurr = array('USD', 'EUR', 'RUB', 'GBP', 'AUD', 'DKK', 'CAD', 'NOK',  'PLN', 'SGD',  'SEK',  'CHF',  'JPY');


function getRates($aCurr)
{
    $dom = new \DOMDocument();
    if($dom->load('http://resources.finance.ua/ru/public/currency-cash.xml') !== TRUE) {
        bff::errors()->set('Ошибка парсинга курсов валют с сайта cbr.ru');
        return false;
    }

    $aCurrencies = array();

    $root = $dom->documentElement; // Получаем корневой элемент
    $nodes = $root->childNodes;
    // Получаем названия требуемых валют
    foreach($nodes as $node){
        if($node->nodeName == 'currencies'){
            $currencies = $node->childNodes;
            foreach($currencies as $c){
                $sCurrID = $c->attributes->getNamedItem('id')->textContent;
                if(in_array($sCurrID, $aCurr)){
                    $sTitle = $c->attributes->getNamedItem('title')->textContent;
                    if( ! empty($sTitle)){
                        $sTitle = mb_strtoupper(mb_substr($sTitle, 0, 1)).mb_substr($sTitle, 1);
                        $aCurrencies[ $sCurrID ] = $sTitle;
                    }
                }
            }
        }
    }
    // Получаем курсы требуемых валют
    $aRates = array();
    foreach($nodes as $node){
        if($node->nodeName == 'organizations'){
            $organisations = $node->childNodes;
            foreach($organisations as $o){
                foreach($o->childNodes as $n){
                    if($n->nodeName == 'currencies'){
                        foreach($n->childNodes as $c){
                            $sCurrID = $c->attributes->getNamedItem('id')->textContent;
                            if(in_array($sCurrID, $aCurr)){
                                $nRateBuy = $c->attributes->getNamedItem('br')->textContent;
                                $nRateSell = $c->attributes->getNamedItem('ar')->textContent;
                                if( ! empty($nRateBuy) && ! empty($nRateSell)){
                                    $aRates[ $sCurrID ][] = array(
                                        'buy'  => $nRateBuy,
                                        'sell' => $nRateSell,
                                    );
                                }
                            }

                        }
                    }
                }
            }
        }
    }
    //Найдем среднее арифметическое курсов
    $aResult = array();
    foreach($aCurr as $id){
        if( ! empty($aRates[$id])){
            $nBuy = 0;
            $nSell = 0;
            foreach($aRates[$id] as $v){
                $nBuy += $v['buy'];
                $nSell += $v['sell'];
            }
            $nCnt = count($aRates[$id]);
            $aResult[$id] = array(
                'id'   => $id,
                't'    => $aCurrencies[ $id ],
                'buy'  => round($nBuy / $nCnt, 4),
                'sell' => round($nSell / $nCnt, 4),
            );
        }
    }

    return array('rates' => $aResult);
}

# Получаем курсы
$aCurrent = getRates($aNeedCurr);
if( empty($aCurrent) ) return;

# Сохраняем в настройки сайта
if( ! empty($aCurrent) && bff::errors()->no()) {
    config::save('business_curr', serialize($aCurrent), false);
}