<?php

/**
 * Курсы валют с сайта cbr.ru
 */

$aCurr = array(
    'USD' => 'Доллар США',
    'EUR' => 'Евро',
    'GBP' => 'Фунт стерлингов Соединенного Королевства',
    'AUD' => 'Австралийский доллар',
    'DKK' => 'Датская крона',
    'CAD' => 'Канадский доллар',
    'NOK' => 'Норвежская крона',
    'SGD' => 'Сингапурский доллар',
    'SEK' => 'Шведская крона',
    'CHF' => 'Швейцарский франк',
    'JPY' => 'Японская иена',
    'UAH' => 'Украинская гривна',
    'PLN' => 'Польский злотый',
);

function getRates($aCurr, $sDate)
{
    $dom = new \DOMDocument('1.0','Windows-1251');
    if($dom->load('http://www.cbr.ru/scripts/XML_daily.asp?date_req='.$sDate) !== TRUE) {
        bff::errors()->set('Ошибка парсинга курсов валют с сайта cbr.ru');
        return false;
    }

    $aResult = array('date'=>'','rates'=>array());

    # Помечаем дату последнего изменения курсов Центробанком
    $aResult['date'] = strtotime( strval($dom->getElementsByTagName('ValCurs')->item(0)->getAttribute('Date')) );

    # Получаем курсы валют
    $aValute = $dom->getElementsByTagName('Valute');
    if( ! empty($aValute) ) {
        foreach($aValute as $v)
        {
            $key = strval($v->childNodes->item(3)->textContent);
            if( ! isset($aCurr[$key]) ) continue;

            $rate = str_replace(',', '.', strval($v->childNodes->item(9)->textContent));

            $aCurr[$key] = array(
                't'     => $aCurr[$key], // Наименование валюты, "Доллар США"
                'code'  => $key, // Код валюты, "USD"
                'm'     => strval($v->childNodes->item(5)->textContent), // Масштаб
                'value' => floatval($rate), // Курс
            );
        }
    }
    $aResult['rates'] = $aCurr;

    return $aResult;
}

# Получаем курсы за сегодня
$aCurrent = getRates($aCurr, date('d.m.Y'));
if( empty($aCurrent) ) return;

# Формируем динамику курсов
# Курсы валют устанавливаются ежедневно, кроме: воскресенье(7), понедельник(1)
$aOffset = array(1=>2,2=>3,3=>1,4=>1,5=>1,6=>1,7=>1);
$nPrevDate = strtotime( -$aOffset[date('N', $aCurrent['date'])].' days', $aCurrent['date']);
$aPrevious = getRates($aCurr, date('d.m.Y', $nPrevDate) );
if( empty($aPrevious['rates']) || sizeof($aPrevious['rates']) != sizeof($aCurrent['rates']) ) return;
foreach($aCurrent['rates'] as $k=>$v)
{
    $prev = $aPrevious['rates'][$k];
    $diff  = round($v['value']/$v['m'] - $prev['value']/$prev['m'], 4);
    $aCurrent['rates'][$k]['diff'] = $diff;
}

# Сохраняем в настройки сайта
if( ! empty($aCurrent) && bff::errors()->no()) {
    config::save('business_curr', serialize($aCurrent), false);
}