<?php

class tpl extends \bff\base\tpl
{
    public static function date_format_pub($mDatetime, $sFormat = 'H:i, d.m.y')
    {
        if( is_string($mDatetime) ) {
            $mDatetime = strtotime($mDatetime);
        }
        return date($sFormat, $mDatetime);
    }

    public static function formatPrice($nPrice, $nCurrencyID)
    {
        static $curr;
        if( ! isset($curr)) {
            $nSelectedID = false;
            $curr = Site::currencyOptions($nSelectedID, false);
        }

        $nPrice = number_format($nPrice, 0, '', ' ');
        if( isset($curr[$nCurrencyID]) ) {
            return $nPrice.' '.$curr[$nCurrencyID]['title_short'];
        } else {
            return $nPrice.' '.Site::currencyDefault();
        }
    }

    /**
     * Формирование блока комментариев
     * @param array $aData
     * @param boolean $bAjax ajax-ответ
     * @param \bff\db\Comments $oComments объект работы с комментариями
     * @return array|mixed
     */
    public static function commentsBlock($aData, $bAjax, \bff\db\Comments $oComments)
    {
        $aHideReasons = $oComments->getHideReasons();
        if($bAjax)
        {
            $aCmt = array();
            foreach ($aData as $commentData) {
                $commentData['hideReasons'] = &$aHideReasons;
                $aCmt[] = array (
                    'id'   => $commentData['id'],
                    'pid'  => $commentData['pid'],
                    'html' => View::renderTemplate($commentData, 'comments.ajax')
                );
            }
            return $aCmt;
        }

        $aData['hideReasons'] = &$aHideReasons;
        return View::renderTemplate($aData, 'comments');
    }

    /**
     * Формирование блока "Поделиться"
     * @param array $params параметры
     *  array 'share_blog_link' - параметры ссылки "Код для блога"
     * @return string
     */
    public static function shareBlock(array $params = array())
    {
        $params = array_merge(array('class'=>'ya'), $params);
        return '<div class="'.$params['class'].'">
                    '._t('', 'Поделиться').':<br />
                    '.config::get('share_code').
                    (!empty($params['share_blog_link'])?'<div class="clear" style="padding-top:6px;"><span class="f12"> &lt; / &gt; <a href="#" class="ajax" onclick="'.$params['share_blog_link']['onclick'].'">'._t('', 'Код для блога').'</a></span></div>':'').'
                    <div class="clear"></div>
                </div>';
    }

    /**
     * Формируем URL капчи
     * @param string $sType тип капчи, варианты: 'math' - математическая (5+2); 'simple' - обычная
     * @param array $aParams параметры, например: 'bg'=>'ffffff' (цвет фона)
     * @return string
     */
    public static function captchaURL($sType = 'math', array $aParams = array('bg'=>'ffffff'))
    {
        $aParams = http_build_query($aParams);
        switch($sType)
        {
            case 'math': {
                return SITEURL.'/captcha2.php?'.$aParams;
            } break;
            case 'simple':
            default: {
                return SITEURL.'/captcha.php?'.$aParams;
            } break;
        }
    }

    public static function date_publicated($mDatetime, $sDateFormat = 'Y-m-d H:i:s', $bTime = true, $sSeparator = ', ')
    {
        static $now, $lng;
        if (!isset($now)) {
            $now = array();
            list($now['year'], $now['month'], $now['day']) = explode(',', date('Y,m,d'));
            $now = array_map('intval', $now);
            $lng = array(
                'today'     => _t('', 'Сегодня'),
                'yesterday' => _t('', 'Вчера'),
            );
        }
        if (!is_string($mDatetime)) {
            $mDatetime = date($sDateFormat, $mDatetime);
        }

        $date = date_parse_from_format($sDateFormat, $mDatetime);
        if (!empty($date['error_count'])) {
            return '';
        }

        if ($now['month'] == $date['month'] && $now['year'] == $date['year']) {
            if ($now['day'] == $date['day']) { # сегодня
                return $lng['today'] . ($bTime ? $sSeparator . sprintf('%01d:%02d', $date['hour'], $date['minute']) : '');
            } else {
                if ($now['day'] == $date['day'] + 1) { # вчера
                    return $lng['yesterday'] . ($bTime ? $sSeparator . sprintf('%01d:%02d', $date['hour'], $date['minute']) : '');
                }
            }
        }
        if($now['year'] == $date['year']){
            return $date['day'] . ' ' . \bff::locale()->getMonthTitle($date['month']);
        }
        return sprintf('%02d.%02d.%d', $date['day'], $date['month'], $date['year']);
    }
}