$(document).ready(() => {
	$('.wheel').superWheel({
		slices: [{
			text: "0",
			value: 0,
			message: "Выигрыш: 0 RUB",
			background: "#000"
		}, {
			text: "5",
			value: 1,
			message: "Выигрыш: 5 RUB",
			background: "#e82a25"
		}, {
			text: "10",
			value: 1,
			message: "Выигрыш: 10 RUB",
			background: "#000"
		}, {
			text: "0",
			value: 0,
			message: "Выигрыш: 0 RUB",
			background: "#e82a25"
		}, {
			text: "15",
			value: 1,
			message: "Выигрыш: 15 RUB",
			background: "#000"
		}, {
			text: "20",
			value: 1,
			message: "Выигрыш: 20 RUB",
			background: "#e82a25"
		}, {
			text: "0",
			value: 0,
			message: "Выигрыш: 0 RUB",
			background: "#000"
		}, {
			text: "25",
			value: 1,
			message: "Выигрыш: 25 RUB",
			background: "#e82a25"
		}, {
			text: "30",
			value: 1,
			message: "Выигрыш: 30 RUB",
			background: "#000"
		}, {
			text: "0",
			value: 0,
			message: "Выигрыш: 0 RUB",
			background: "#e82a25"
		}, {
			text: "jackpot",
			value: 2,
			message: "Выигрыш: 50 RUB",
			background: "#32c538"
		}],
		text : {
			color: '#fff',
		},
		line: {
			width: 4,
			color: "#FDD835"
		},
		outer: {
			width: 8,
			color: "#FDD835"
		},
		inner: {
			width: 14,
			color: "#FDD835"
		},
		marker: {
			background: "#c51e1e",
			animate: 1
		},
		selector: "value",
	});

	const send = (result) => {
		$.ajax({
			type: 'POST',
			url: 'https://100loto.best/fortune/result.php',
			data: {
				result
			},
			error: (error) => {
				swal("Ошибка!", error.statusText, "error")
			}
		})
	};

	let tick = new Audio('./assets/tick.mp3');

	$(document).on('click', '.wheel-spin-button', function(e) {
		$('.wheel').superWheel('start','value', Math.floor(Math.random() * 2));
		$(this).prop('disabled', true);
	});

	$('.wheel').superWheel('onStart', (results) => {
		$('.wheel-spin-button').text('Крутим...');
	});

	$('.wheel').superWheel('onStep', (results) => {
		if (typeof tick.currentTime !== 'undefined')
			tick.currentTime = 0;
		tick.play();
	});

	$('.wheel').superWheel('onComplete', (results) => {
		if (results.value === 2) {
			send(results.text);
			swal({
				type: 'success',
				title: "JACKPOT!", 
				html: results.message
			});
		} else if (results.value === 1) {
			send(results.text);
			swal({
				type: 'success',
				title: "Поздравляю!", 
				html: results.message
			});
		} else {
send(results.text);
			swal("Увы...", results.message, "error");
		}






		$('.wheel-spin-button:disabled').prop('disabled', false).text('Крутить ещё');
	})
});
