<?php
/**
 * @var \ui\Page $ui
 * @var \ui\User_Header $user_header
 * @var \ui\User_Footer $user_footer
 * @var \ui\Footer $footer
 * @var \ui\Breadcrumbs $breadcrumbs
 */
?>
<!DOCTYPE html PUBLIC "-//WAPFORUM//DTD XHTML Mobile 1.0//EN" "http://www.wapforum.org/DTD/xhtml-mobile10.dtd">
<html>
<head>
    <title><?php echo \Text::toValue($ui->getTitle()) ?></title>
    <link rel="shortcut icon" href="/favicon.ico?v=3" type="image/x-icon">
    <?php
    foreach ($ui->getStyles() AS $href) {
        $href = \Text::toValue($href);
        echo "<link rel='stylesheet' type='text/css' href='{$href}'>" . PHP_EOL;
    }
    foreach ($ui->getScripts() AS $src) {
        $src = \Text::toValue($src);
        echo "<script type='text/javascript' src='{$src}'></script>" . PHP_EOL;
    } ?>
</head>
<body>
<table>
    <tr>
        <td class="border_angle_left_top"></td>
        <td class="border_horizontal"></td>
        <td class="border_angle_top_right"></td>
    </tr>
    <tr>
        <td class="border_vertical"></td>
        <td id="page">
            <?php if ($breadcrumbs = $ui->findLink('ui\Breadcrumbs_1')) { ?>
                <?php if ($breadcrumbs->getBreadcrumbs()) { ?>
                    <?php echo $breadcrumbs ?>
                <?php } ?>
            <?php } ?>
            <?php if ($user_header = $ui->findLink('ui\User_Header_1')) { ?>
                <?php echo $user_header ?>
                <div class="block">
                    <div class="left"></div>
                    <div class="right"></div>
                </div>
            <?php } ?>
            <?php foreach ($ui->getItems() AS $item) { ?>
                <?php echo $item ?>
            <?php } ?>
            <?php if ($user_footer = $ui->findLink('ui\User_Footer_1')) { ?>
                <?php if ($user_footer->getMenus()) { ?>
                    <div class="block">
                        <div class="left"></div>
                        <div class="right"></div>
                    </div>
                    <?php echo $user_footer ?>
                <?php } ?>
            <?php } ?>
        </td>
        <td class="border_vertical"></td>
    </tr>
    <tr>
        <td class="border_angle_bottom_left"></td>
        <td class="border_horizontal"></td>
        <td class="border_angle_right_bottom"></td>
    </tr>
</table>
<div id="content" style="text-align: center">
    <?php if ($footer = $ui->findLink('ui\Footer_1')) { ?>
        <?php if ($footer->getMenus()) { ?>
            <?php echo $footer ?>
        <?php } ?>
    <?php } ?>
    <div id="item">
        <div style="color: #f1f1f1">Генерация: {exec_time} сек | Память: {mem_usage} кб</div>
    </div>
</div>
</body>
</html>
