<?php
/**
 * @var \core\Request $request
 * @var \core\View $view
 */

$error_messages = [];
switch ($request->get('auth') ?? 'login') {
    case 'register'; // Регистрация
        if ($request->isMethodPost() AND !$error_messages) {
            $login = $request->post('login', FILTER_SANITIZE_STRING);
            $password = $request->post('password', FILTER_SANITIZE_STRING);
            $confirm_password = $request->post('confirm_password', FILTER_SANITIZE_STRING);
            $sex = $request->post('sex', FILTER_SANITIZE_NUMBER_INT);
            $email = $request->post('email', FILTER_SANITIZE_EMAIL);

            /** @var \PDO $connection */
            $connection = Registry::get('connection');

            // Проверка почты
            if (empty($email)) {
                $error_messages[] = 'Вы не ввели адрес электронной почты!';
            } else {
                if (!preg_match("/[0-9a-z_]+@[0-9a-z_^\.]+\.[a-z]{2,3}/i", $email)
                    || substr_count($email, " ") != 0
                    || substr_count($email, "\\") != 0
                ) {
                    $error_messages[] = 'Неправильно введён адрес электронной почты (формат: login@mail.net)!';
                }

                // Проверка почты на присутствие у юзеров
                if (!$error_messages) {
                    $find = $connection->prepare("SELECT * FROM `accounts` WHERE email = ? LIMIT 1");
                    $find->execute([$email]);

                    if ($data = $find->fetch()) {
                        $error_messages[] = 'Такой адрес электронной почты уже используется другим пользователем';
                    }
                }
            }

            // Проверка пола
            if ($sex != 0 && $sex != 1) {
                $error_messages[] = 'Неизвестный выбраный пол';
            }

            // Проверка логина
            if (empty($login)) {
                $error_messages[] = 'Не введён логин';
            } elseif (mb_strlen($login) < 4 || mb_strlen($login) > 15) {
                $error_messages[] = 'Недопустимая длина логина';
            } elseif (preg_match("/[^0-9A-z\-\_\.]+/", $login)) {
                $error_messages[] = 'Недопустимые символы в логине';
            } else {
                $find = $connection->prepare("SELECT * FROM `accounts` WHERE login = ? LIMIT 1");
                $find->execute([$login]);

                if ($data = $find->fetch()) {
                    $error_messages[] = 'Этот логин уже зарегистрирован, выберите другой';
                }
            }

            // Проверка пароля
            if (empty($password)) {
                $error_messages[] = 'Не введён пароль';
            } elseif (mb_strlen($password) < 4) {
                $error_messages[] = 'Недопустимая длина пароля';
            } elseif ($password != $confirm_password) {
                $error_messages[] = 'Пароли не совпадают';
            } elseif (preg_match("/[^\da-zA-Z_]+/", $password)) {
                $error_messages[] = 'Недопустимые символы в пароле!';
            }

            // Создаем аккаунт
            if (!$error_messages) {
                $hash_salt = generator();
                $hash_password = md5($password . $hash_salt);

                $res = $connection->prepare("INSERT INTO `accounts` 
                (login, hash_password, hash_salt, email, data_register) VALUES (?, ?, ?, ?, ?)");
                $res->execute([$login, $hash_password, $hash_salt, $email, time()]);

                $_SESSION['auth_token'] = User::generateAuthToken($connection->lastInsertId());
                $redirect = new \core\response\Redirect();
                $redirect->setUrl(new \core\Url('/'));
                return $redirect;
            }
        }

        /** @var \ui\Page $page */
        $page = Registry::get('page');
        $page->setTitle('Регистрация');

        $view->assign('error_messages', $error_messages);
        $view->assign('login', $login ?? false);
        $view->assign('password', $password ?? false);
        $view->assign('confirm_password', $confirm_password ?? false);
        $view->assign('email', $email ?? false);
        $view->assign('sex', $sex ?? 0);

        return $view->render('index.register');
        break;
    default:
        if ($request->isMethodPost()) {
            $login = $request->post('login', FILTER_SANITIZE_STRING);
            $password = $request->post('password', FILTER_SANITIZE_STRING);

            /** @var \PDO $connection */
            $connection = Registry::get('connection');

            // Проверка логина
            if (empty($login)) {
                $error_messages[] = 'Не введён логин';
            } elseif (mb_strlen($login) < 4 || mb_strlen($login) > 15) {
                $error_messages[] = 'Недопустимая длина логина';
            } elseif (preg_match("/[^0-9A-z\-\_\.]+/", $login)) {
                $error_messages[] = 'Недопустимые символы в логине';
            }

            // Проверка пароля
            if (empty($password)) {
                $error_messages[] = 'Не введён пароль';
            } elseif (mb_strlen($password) < 4) {
                $error_messages[] = 'Недопустимая длина пароля';
            } elseif (preg_match("/[^\da-zA-Z_]+/", $password)) {
                $error_messages[] = 'Недопустимые символы в пароле!';
            }

            if (!$error_messages) {
                $find = $connection->prepare("SELECT * FROM `accounts` WHERE login = ? LIMIT 1");
                $find->execute([$login]);

                if (!$account = $find->fetch()) {
                    $error_messages[] = 'Этот логин не зарегистрирован';
                }

                if (!$error_messages) {
                    if (md5($password . $account['hash_salt']) != $account['hash_password']) {
                        $error_messages[] = 'Не верно веден пароль';
                    }
                }

                if (!$error_messages) {
                    $_SESSION['auth_token'] = User::generateAuthToken($account['id']);
                    $redirect = new \core\response\Redirect();
                    $redirect->setUrl(new \core\Url('/'));
                    return $redirect;
                }
            }
        }

        /** @var \ui\Page $page */
        $page = Registry::get('page');
        $page->setTitle('Авторизация');

        $view->assign('error_messages', $error_messages);
        $view->assign('login', $login ?? false);
        $view->assign('password', $password ?? false);

        return $view->render('index.login');
        break;
}