<?php
/**
 * @var \data\Profession[] $professions
 * @var \ui\Pagination $pagination
 * @var array $messages
 */
?>
<div id="content">
    <?php foreach ($messages AS $message) { ?>
        <div id="item">
            <div class="<?= $message['type'] ?>">
                <div id="content">
                    <div id="item">
                        <?= $message['text'] ?>
                    </div>
                </div>
            </div>
        </div>
    <?php } ?>
    <div id="item">
        <div id="listing">
            <?php if ($professions) { ?>
                <?php foreach ($professions AS $profession) { ?>
                    <a id="content" href="<?= new \core\Url('/manager/profession', ['id' => $profession->id]) ?>">
                        <table>
                            <td>
                                <div id="item">
                                    <span class="image shadow">
                                        <img style="width: 40px;" src="/public/images/professions/<?= $profession->icon ?>">
                                    </span>
                                </div>
                            </td>
                            <td style="width: 100%">
                                <div id="item">
                                    <?= $profession->title ?>
                                </div>
                            </td>
                        </table>
                    </a>
                <?php } ?>
            <?php } else { ?>
                <div id="content">
                    <div id="item">
                        Нет список профессии
                    </div>
                </div>
            <?php } ?>
        </div>
        <?php if ($pagination->getCountPages() > 1) { ?>
            <?= $pagination ?>
        <?php } ?>
    </div>
    <div id="item">
        <a type="button" href="/manager/professions/add">Создать профессия</a>
    </div>
</div>