<?php
/**
 * @var \data\Profession $profession
 * @var \ui\Pagination $pagination
 * @var \data\Recipe[] $recipes
 * @var array $messages
 */
?>
<div id="content">
    <?php foreach ($messages AS $message) { ?>
        <div id="item">
            <div class="<?= $message['type'] ?>">
                <div id="content">
                    <div id="item">
                        <?= $message['text'] ?>
                    </div>
                </div>
            </div>
        </div>
    <?php } ?>
    <div id="item">
        <div id="listing">
            <div id="content">
                <table>
                    <td>
                        <div id="item">
                            <span class="image shadow">
                                <img style="width: 52px;" src="/public/images/professions/<?= $profession->icon ?>">
                            </span>
                        </div>
                    </td>
                    <td style="width: 100%">
                        <div id="item">
                            <?= $profession->title ?>
                        </div>
                    </td>
                </table>
            </div>
            <?php if ($recipes) { ?>
                <?php foreach ($recipes AS $recipe) { ?>
                    <a id="content" href="<?= new \core\Url('/manager/recipe', [
                        'profession' => $profession->id,
                        'id' => $recipe->id
                    ]) ?>">
                        <table>
                            <td>
                                <div id="item">
                            <span class="image shadow">
                                <img style="width: 40px;" src="/public/images/items/<?= $recipe->icon ?>">
                            </span>
                                </div>
                            </td>
                            <td style="width: 100%">
                                <div id="item">
                                    <?= $recipe->title ?>
                                </div>
                            </td>
                        </table>
                    </a>
                <?php } ?>
            <?php } else { ?>
                <div id="content">
                    <div id="item">
                        Нет список рецептов
                    </div>
                </div>
            <?php } ?>
        </div>
        <?php if ($pagination->getCountPages() > 1) { ?>
            <?= $pagination ?>
        <?php } ?>
    </div>
    <div id="item">
        <div id="actions">
            <a id="content" href="<?= new \core\Url('/manager/profession/recipes/add', ['id' => $profession->id]) ?>">
                <div id="item">Создать рецепт</div>
            </a>
            <a id="content" href="<?= new \core\Url('/manager/profession/edit', ['id' => $profession->id]) ?>">
                <div id="item">Редактировать</div>
            </a>
            <a id="content" href="<?= new \core\Url('/manager/profession/icon', ['id' => $profession->id]) ?>">
                <div id="item">Изменить иконку</div>
            </a>
            <a id="content" href="<?= new \core\Url('/manager/profession/delete', ['id' => $profession->id]) ?>">
                <div id="item">Удалить</div>
            </a>
        </div>
    </div>
</div>