<?php
/**
 * @var \data\Item[] $items
 * @var \ui\Pagination $pagination
 * @var array $messages
 */
?>
<div id="content">
    <?php foreach ($messages AS $message) { ?>
        <div id="item">
            <div class="<?= $message['type'] ?>">
                <div id="content">
                    <div id="item">
                        <?= $message['text'] ?>
                    </div>
                </div>
            </div>
        </div>
    <?php } ?>
    <div id="item">
        <div id="listing">
            <?php if ($items) { ?>
                <?php foreach ($items AS $item) { ?>
                    <a id="content" href="<?= new \core\Url('/manager/item', ['id' => $item->id]) ?>">
                        <table>
                            <td>
                                <div id="item">
                                    <span class="image shadow">
                                        <img style="width: 40px;" src="/public/images/items/<?= $item->icon ?>">
                                        <?php if ($item->count > 1) { ?>
                                            <div class="count"><?= $item->count ?></div>
                                        <?php } ?>
                                    </span>
                                </div>
                            </td>
                            <td style="width: 100%">
                                <div id="item">
                                    <?= $item->title ?>
                                </div>
                            </td>
                        </table>
                    </a>
                <?php } ?>
            <?php } else { ?>
                <div id="content">
                    <div id="item">
                        Нет список предметов
                    </div>
                </div>
            <?php } ?>
        </div>
        <?php if ($pagination->getCountPages() > 1) { ?>
            <?= $pagination ?>
        <?php } ?>
    </div>
    <div id="item">
        <a type="button" href="/manager/items/add">Создать предмет</a>
    </div>
</div>