<?php
/**
 * @var ui\Page $page
 * @var ui\Breadcrumbs $breadcrumbs
 * @var \PDO $connection
 */

if (!$profession = Core::findProfession($request->get('profession', FILTER_SANITIZE_NUMBER_INT))) {
    $redirect = new core\response\Redirect();
    $redirect->setUrl((new \core\Url('/manager/professions')));
    return $redirect;
}

if (!$recipe = $profession->findRecipe($request->get('id', FILTER_SANITIZE_NUMBER_INT))) {
    $redirect = new core\response\Redirect();
    $redirect->setUrl((new \core\Url('/manager/profession', ['id' => $profession->id])));
    return $redirect;
}

$connection = Registry::get('connection');
$page = Registry::get('page');

if ($breadcrumbs = $page->findLink('ui\Breadcrumbs_1')) {
    $breadcrumbs->addBreadcrumb('/manager', 'Панель управления');
    $breadcrumbs->addBreadcrumb('/manager/professions', 'Професии');
    $breadcrumbs->addBreadcrumb(new \core\Url('/manager/profession', ['id' => $profession->id]), $profession->title);
    $breadcrumbs->addBreadcrumb(null, $recipe->title);
}

$view->assign('profession', $profession);
$view->assign('recipe', $recipe);
$view->assign('messages', Flash::getMessages());
return $view->render('manager.recipe');


