<?php
/**
 * @var \package\Module $this
 * @var \core\Request $request
 * @var \Component $component
 * @var \core\View $view
 * @var \ui\Breadcrumbs $breadcrumbs
 */

/**
 * @var ui\Page $page
 */
$page = Registry::get('page');
if ($breadcrumbs = $page->findLink('ui\Breadcrumbs_1')) {
    $breadcrumbs->addBreadcrumb('/manager', 'Панель управления');
    $breadcrumbs->addBreadcrumb(null, 'Професии');
}

$pagination = new \ui\Pagination();
$pagination->setCountAllItems(Core::getCountProfessions());
$professions = Core::getProfessions($pagination->_getMySqlLimit());

$view->assign('pagination', $pagination);
$view->assign('professions', $professions);
$view->assign('messages', Flash::getMessages());
return $view->render('manager.professions');


