<?php
/**
 * @var ui\Page $page
 * @var ui\Breadcrumbs $breadcrumbs
 * @var \PDO $connection
 */

$connection = Registry::get('connection');
$page = Registry::get('page');
if ($breadcrumbs = $page->findLink('ui\Breadcrumbs_1')) {
    $breadcrumbs->addBreadcrumb('/manager', 'Панель управления');
    $breadcrumbs->addBreadcrumb('/manager/professions', 'Профессии');
    $breadcrumbs->addBreadcrumb(null, 'Создать профессия');
}

$icons = [];
if ($dh = opendir(DIR_HOME . '/public/images/professions')) {
    while (($name = readdir($dh)) !== false) {
        if ($name == '.' || $name == '..') {
            continue;
        }

        $icons[$name] = true;
    }
}
closedir($dh);

if ($request->isMethodPost()) {
    $input_title = $request->post('title', FILTER_SANITIZE_STRING);
    $input_icon = $request->post('icon', FILTER_SANITIZE_STRING);

    // Проверка название предмета
    if (empty($input_title)) {
        Flash::addMessageError('Не введён название предмета');
    } else {
        $find = $connection->prepare("SELECT * FROM `professions` WHERE title = ? LIMIT 1");
        $find->execute([$input_title]);

        if ($data = $find->fetch()) {
            Flash::addMessageError('Этот профессия уже создан, выберите другой');
        }
    }

    if (!isset($icons[$input_icon])) {
        Flash::addMessageError('Указан не правильный иконка професия');
    }

    if (!Flash::getMessages(false)) {
        Flash::addMessageSuccess("Професия '{$input_title}' создан");

        $item = new \data\Profession();
        $item->title = $input_title;
        $item->icon = $input_icon;

        $redirect = new \core\response\Redirect();
        $redirect->setUrl(new \core\Url('/manager/professions'));
        return $redirect;
    }
}

$view->assign('input_title', $input_title ?? null);
$view->assign('input_icon', $input_icon ?? null);
$view->assign('icons', $icons);
$view->assign('messages', Flash::getMessages());
return $view->render('manager.professions.add');


