<?php
/**
 * @var ui\Page $page
 * @var ui\Breadcrumbs $breadcrumbs
 * @var \PDO $connection
 */

if (!$profession = Core::findProfession($request->get('id', FILTER_SANITIZE_NUMBER_INT))) {
    $redirect = new core\response\Redirect();
    $redirect->setUrl((new \core\Url('/manager/professions')));
    return $redirect;
}

$connection = Registry::get('connection');
$page = Registry::get('page');

if ($breadcrumbs = $page->findLink('ui\Breadcrumbs_1')) {
    $breadcrumbs->addBreadcrumb('/manager', 'Панель управления');
    $breadcrumbs->addBreadcrumb('/manager/professions', 'Професии');
    $breadcrumbs->addBreadcrumb(new \core\Url('/manager/profession', ['id' => $profession->id]), $profession->title);
    $breadcrumbs->addBreadcrumb(null, 'Создать рецепт');
}

if ($request->isMethodPost()) {
    $input_title = $request->post('title', FILTER_SANITIZE_STRING);

    // Проверка название предмета
    if (empty($input_title)) {
        Flash::addMessageError('Не введён название рецепта');
    } else {
        $find = $connection->prepare("SELECT * FROM `profession_recipes` WHERE title = ? LIMIT 1");
        $find->execute([$input_title]);

        if ($data = $find->fetch()) {
            Flash::addMessageError('Этот рецепт уже создан, выберите другой');
        }
    }

    if (!Flash::getMessages(false)) {
        Flash::addMessageSuccess("Рецепт '{$input_title}' создан");

        $recipe = new \data\Recipe();
        $recipe->profession_id = $profession->id;
        $recipe->title = $input_title;

        $redirect = new \core\response\Redirect();
        $redirect->setUrl(new \core\Url('/manager/profession', ['id' => $profession->id]));
        return $redirect;
    }
}

$view->assign('input_title', $input_title ?? null);
$view->assign('messages', Flash::getMessages());
return $view->render('manager.profession.recipes.add');


