<?php
/**
 * @var ui\Page $page
 * @var ui\Breadcrumbs $breadcrumbs
 * @var \PDO $connection
 */

if (!$profession = Core::findProfession($request->get('id', FILTER_SANITIZE_NUMBER_INT))) {
    $redirect = new core\response\Redirect();
    $redirect->setUrl((new \core\Url('/manager/professions')));
    return $redirect;
}

$connection = Registry::get('connection');
$page = Registry::get('page');
if ($breadcrumbs = $page->findLink('ui\Breadcrumbs_1')) {
    $breadcrumbs->addBreadcrumb('/manager', 'Панель управления');
    $breadcrumbs->addBreadcrumb('/manager/professions', 'Професии');
    $breadcrumbs->addBreadcrumb(null, $profession->title);
}

$pagination = new \ui\Pagination();
$pagination->setCountAllItems($profession->getCountRecipes());
$recipes = $profession->getRecipes($pagination->_getMySqlLimit());

$view->assign('pagination', $pagination);
$view->assign('recipes', $recipes);
$view->assign('profession', $profession);
$view->assign('messages', Flash::getMessages());
return $view->render('manager.profession');


