<?php
/**
 * @var ui\Page $page
 * @var ui\Breadcrumbs $breadcrumbs
 * @var \PDO $connection
 */

if (!$profession = Core::findProfession($request->get('id', FILTER_SANITIZE_NUMBER_INT))) {
    $redirect = new core\response\Redirect();
    $redirect->setUrl((new \core\Url('/manager/items')));
    return $redirect;
}

$page = Registry::get('page');

if ($breadcrumbs = $page->findLink('ui\Breadcrumbs_1')) {
    $breadcrumbs->addBreadcrumb('/manager', 'Панель управления');
    $breadcrumbs->addBreadcrumb('/manager/professions', 'Професии');
    $breadcrumbs->addBreadcrumb(new \core\Url('/manager/profession', ['id' => $profession->id]), $profession->title);
    $breadcrumbs->addBreadcrumb(null, 'Изменить иконку');
}

$icons = [];
if ($dh = opendir(DIR_HOME . '/public/images/professions')) {
    while (($name = readdir($dh)) !== false) {
        if ($name == '.' || $name == '..') {
            continue;
        }

        $icons[] = $name;
    }
}
closedir($dh);

$pagination = new \ui\Pagination();
$pagination->setCountAllItems(count($icons));

$icon_name = $profession->icon;
if($icon_id = (int) $request->get('icon_id', FILTER_SANITIZE_NUMBER_INT)) {
    if (isset($icons[$icon_id])) {
        $icon_name = $icons[$icon_id];
    }
}

if ($request->isMethodPost()) {
    if (!$icons[$icon_id]) {
        Flash::addMessageError('Указан не правильный иконка предмета');
    }

    if (!Flash::getMessages(false)) {
        Flash::addMessageSuccess("Профессия '{$profession->title}' установлен новая иконка");

        $profession->icon = $icons[$icon_id];

        $redirect = new \core\response\Redirect();
        $redirect->setUrl(new \core\Url());
        return $redirect;
    }
}

$view->assign('pagination', $pagination);
$view->assign('profession', $profession);
$view->assign('icon_name', $icon_name);
$view->assign('icons', $icons);
$view->assign('messages', Flash::getMessages());
return $view->render('manager.profession.icon');


