<?php
/**
 * @var \package\Module $this
 * @var \core\Request $request
 * @var \Component $component
 * @var \core\View $view
 * @var \ui\Breadcrumbs $breadcrumbs
 * @var ui\Page $page
 */


if ($name = $request->get('name')) {
    if (!$this->hasComponent($name)) {
        $redirect = new core\response\Redirect();
        $redirect->setUrl((new \core\Url(null))->removeParam('name'));
        return $redirect;
    }

    $component = $this->findComponent($name);

    if ($component->isSystem()) {
        $redirect = new core\response\Redirect();
        $redirect->setUrl((new \core\Url(null))->removeParam('name'));
        return $redirect;
    }

    $info = $component->findConfig('info');
    $page = Registry::get('page');
    $page->setTitle("Модуль - {$info['title']}");
    if ($breadcrumbs = $page->findLink('ui\Breadcrumbs_1')) {
        $breadcrumbs->addBreadcrumb('/manager', 'Панель управления');
        $breadcrumbs->addBreadcrumb('/manager/modules', 'Модули');
        $breadcrumbs->addBreadcrumb(null, "Модуль - {$info['title']}");
    }

    $view->assign('component', $component);
    return $view->render('manager.module');
}

$page = Registry::get('page');
$page->setTitle("Модули");
if ($breadcrumbs = $page->findLink('ui\Breadcrumbs_1')) {
    $breadcrumbs->addBreadcrumb('/manager', 'Панель управления');
    $breadcrumbs->addBreadcrumb(null, 'Модули');
}

$modules = [];
foreach ($this->getComponents() AS $name => $component) {
    if ($component->isSystem()) {
        continue;
    }

    $info = $component->findConfig('info');
    if (isset($info['title'])) {
        $modules[$info['title']] = $component;
    }
}

$view->assign('modules', $modules);
return $view->render('manager.modules');
