<?php
/**
 * @var ui\Page $page
 * @var ui\Breadcrumbs $breadcrumbs
 * @var \PDO $connection
 */

$connection = Registry::get('connection');
$page = Registry::get('page');
if ($breadcrumbs = $page->findLink('ui\Breadcrumbs_1')) {
    $breadcrumbs->addBreadcrumb('/manager', 'Панель управления');
    $breadcrumbs->addBreadcrumb('/manager/items', 'Предметы');
    $breadcrumbs->addBreadcrumb(null, 'Создать предмет');
}

$types = $connection->query("SELECT id, title FROM item_types")->fetchAll(\PDO::FETCH_UNIQUE);
$icons = [];
if ($dh = opendir(DIR_HOME . '/public/images/items')) {
    while (($name = readdir($dh)) !== false) {
        if ($name == '.' || $name == '..') {
            continue;
        }

        $icons[$name] = true;
    }
}
closedir($dh);

if ($request->isMethodPost()) {
    $input_title = $request->post('title', FILTER_SANITIZE_STRING);
    $input_type = $request->post('type', FILTER_SANITIZE_NUMBER_INT);
    $input_icon = $request->post('icon', FILTER_SANITIZE_STRING);

    // Проверка название предмета
    if (empty($input_title)) {
        Flash::addMessageError('Не введён название предмета');
    } else {
        $find = $connection->prepare("SELECT * FROM `items` WHERE title = ? LIMIT 1");
        $find->execute([$input_title]);

        if ($data = $find->fetch()) {
            Flash::addMessageError('Этот предмет уже создан, выберите другой');
        }
    }

    if ($input_type != 0 && !isset($types[$input_type])) {
        Flash::addMessageError('Указан не правильный тип предмета');
    }

    if (!isset($icons[$input_icon])) {
        Flash::addMessageError('Указан не правильный иконка предмета');
    }

    if (!Flash::getMessages(false)) {
        Flash::addMessageSuccess("Предмет '{$input_title}' создан");

        $item = new \data\Item();
        $item->title = $input_title;
        $item->type = $input_type;
        $item->icon = $input_icon;

        $redirect = new \core\response\Redirect();
        $redirect->setUrl(new \core\Url('/manager/items'));
        return $redirect;
    }
}



$view->assign('input_title', $input_title ?? null);
$view->assign('input_type', $input_type ?? null);
$view->assign('input_icon', $input_icon ?? null);
$view->assign('icons', $icons);
$view->assign('types', $types);
$view->assign('messages', Flash::getMessages());
return $view->render('manager.items.add');


