<?php
/**
 * @var ui\Page $page
 * @var ui\Breadcrumbs $breadcrumbs
 * @var \PDO $connection
 */

if (!$item = Core::findItem($request->get('id', FILTER_SANITIZE_NUMBER_INT))) {
    $redirect = new core\response\Redirect();
    $redirect->setUrl((new \core\Url('/manager/items')));
    return $redirect;
}

$page = Registry::get('page');

if ($breadcrumbs = $page->findLink('ui\Breadcrumbs_1')) {
    $breadcrumbs->addBreadcrumb('/manager', 'Панель управления');
    $breadcrumbs->addBreadcrumb('/manager/items', 'Предметы');
    $breadcrumbs->addBreadcrumb(new \core\Url('/manager/item', ['id' => $item->id]), $item->title);
    $breadcrumbs->addBreadcrumb(null, 'Изменить иконку');
}

$icons = [];
if ($dh = opendir(DIR_HOME . '/public/images/items')) {
    while (($name = readdir($dh)) !== false) {
        if ($name == '.' || $name == '..') {
            continue;
        }

        $icons[] = $name;
    }
}
closedir($dh);

$pagination = new \ui\Pagination();
$pagination->setCountAllItems(count($icons));

$icon_name = $item->icon;
if($icon_id = (int) $request->get('icon_id', FILTER_SANITIZE_NUMBER_INT)) {
    if ($icons[$icon_id]) {
        $icon_name = $icons[$icon_id];
    }
}

if ($request->isMethodPost()) {
    if (!$icons[$icon_id]) {
        Flash::addMessageError('Указан не правильный иконка предмета');
    }

    if (!Flash::getMessages(false)) {
        Flash::addMessageSuccess("Предмет '{$item->title}' установлен новая иконка");

        $item->icon = $icons[$icon_id];

        $redirect = new \core\response\Redirect();
        $redirect->setUrl(new \core\Url());
        return $redirect;
    }
}

$view->assign('pagination', $pagination);
$view->assign('item', $item);
$view->assign('icon_name', $icon_name);
$view->assign('icons', $icons);
$view->assign('messages', Flash::getMessages());
return $view->render('manager.item.icon');


