<?php
/**
 * @var ui\Page $page
 * @var ui\Breadcrumbs $breadcrumbs
 * @var \PDO $connection
 */

if (!$item = Core::findItem($request->get('id', FILTER_SANITIZE_NUMBER_INT))) {
    $redirect = new core\response\Redirect();
    $redirect->setUrl((new \core\Url('/manager/items')));
    return $redirect;
}

$connection = Registry::get('connection');
$page = Registry::get('page');

$types = $connection->query("SELECT id, title FROM item_types")->fetchAll(\PDO::FETCH_UNIQUE);

if ($breadcrumbs = $page->findLink('ui\Breadcrumbs_1')) {
    $breadcrumbs->addBreadcrumb('/manager', 'Панель управления');
    $breadcrumbs->addBreadcrumb('/manager/items', 'Предметы');
    $breadcrumbs->addBreadcrumb(new \core\Url('/manager/item', ['id' => $item->id]), $item->title);
    $breadcrumbs->addBreadcrumb(null, 'Редактировать');
}

if ($request->isMethodPost()) {
    $input_type = (int) $request->post('type', FILTER_SANITIZE_NUMBER_INT);
    $input_count = (int) $request->post('count', FILTER_SANITIZE_NUMBER_INT);

    if ($input_type != 0 && !isset($types[$input_type])) {
        Flash::addMessageError('Указан не правильный тип предмета');
    }

    if ($input_count < 1 OR 1000 < $input_count) {
        Flash::addMessageError('Укажите правильное количеств стаков предмета от 1 до 1000');
    }

    if (!Flash::getMessages(false)) {
        Flash::addMessageSuccess("Предмет '{$item->title}' редактирован");

        $item->type = $input_type;
        $item->count = $input_count;

        $redirect = new \core\response\Redirect();
        $redirect->setUrl(new \core\Url());
        return $redirect;
    }
}

$view->assign('types', $types);
$view->assign('item', $item);
$view->assign('messages', Flash::getMessages());
return $view->render('manager.item.edit');


