<?php
/**
 * @var ui\Page $page
 * @var ui\Breadcrumbs $breadcrumbs
 * @var \PDO $connection
 */

if (!$item = Core::findItem($request->get('id', FILTER_SANITIZE_NUMBER_INT))) {
    $redirect = new core\response\Redirect();
    $redirect->setUrl((new \core\Url('/manager/items')));
    return $redirect;
}

$connection = Registry::get('connection');
$page = Registry::get('page');

if ($breadcrumbs = $page->findLink('ui\Breadcrumbs_1')) {
    $breadcrumbs->addBreadcrumb('/manager', 'Панель управления');
    $breadcrumbs->addBreadcrumb('/manager/items', 'Предметы');
    $breadcrumbs->addBreadcrumb(new \core\Url('/manager/item', ['id' => $item->id]), $item->title);
    $breadcrumbs->addBreadcrumb(null, 'Удалить');
}


if ($request->isMethodPost()) {

}

$view->assign('item', $item);
$view->assign('messages', Flash::getMessages());
return $view->render('manager.item.delete');


