<?php
/**
 * @var array $messages
 * @var \data\Seed $seed
 * @var \data\Item $item
 * @var \data\Account_Profession $account_profession
 * @var bool $is_add
 */
?>
<div id="content">
    <?php foreach ($messages AS $message) { ?>
        <div id="item">
            <div id="content" class="<?= $message['type'] ?>">
                <div id="item"><?= $message['text'] ?></div>
            </div>
        </div>
    <?php } ?>
    <div id="item">
        <div id="listing">
            <div id="content">
                <div id="item">
                    <?php echo ($seed->item_count > 1 ? '[x' . $seed->item_count . '] ' : null) . $item->title ?>
                </div>
                <table>
                    <tr>
                        <td>
                            <div id="item">
                                <span class="image shadow">
                                    <img style="width: 40px;" src="/public/images/items/<?php echo $item->icon ?>">
                                    <?php if ($seed->item_count > 1) { ?>
                                        <div class="count"><?php echo $seed->item_count ?></div>
                                    <?php } ?>
                                </span>
                            </div>
                        </td>
                        <td style="width: 100%">
                            <div id="item">
                                <?php
                                if (User::getAccount()->energy < $seed->energy) {
                                    echo '<b style="color: darkred">Энергия: ' . $seed->energy . '</b>';
                                } else {
                                    echo '<b>Энергия: ' . $seed->energy . '</b>';
                                }
                                ?>
                            </div>
                        </td>
                    </tr>
                </table>
            </div>
            <div id="content">
                <div id="item">
                    <?php echo sprintf('<span>Время вырашивание зерно: %s</span>',
                        when($seed->time_life, true)
                    ) ?>
                </div>
            </div>
            <?php
            if ($result_items = $seed->getResultItems()) {
                /** @var \PDO $connection */
                $connection = \Registry::get('connection');

                echo '<div id="content">';
                echo '<div id="item"><b>Получаемые ресурсы</b></div>';
                echo '<table>';
                foreach ($result_items AS $data_item) {
                    $result_item = Core::findItem($data_item['item_id']);

                    echo '<tr>';
                    echo '<td>';
                    ?>
                    <div id="item">
                                <span class="image shadow">
                                    <img style="width: 40px;" src="/public/images/items/<?php echo $result_item->icon ?>">
                                    <?php if ($data_item['count'] > 1) { ?>
                                        <div class="count"><?php echo $data_item['count'] ?></div>
                                    <?php } ?>
                                </span>
                    </div>
                    <?php
                    echo '</td>';
                    echo '<td style="width: 100%">';
                    echo '<div id="item">';
                    echo $result_item->title;
                    echo '</div>';
                    echo '</td>';
                    echo '</tr>';
                }
                echo '</table>';
                echo '</div>';
            }
            ?>
        </div>
    </div>
    <?php if ($is_add) { ?>
        <form id="form" action="" method="post">
            <div id="item">
                <input type="submit" value="Посадить">
            </div>
        </form>
    <?php } ?>
</div>
