<?php
/**
 * @var array $messages
 * @var array $seeds
 * @var bool $is_add
 */
?>
<div id="content">
    <?php foreach ($messages AS $message) { ?>
        <div id="item">
            <div id="content" class="<?= $message['type'] ?>">
                <?= $message['text'] ?>
            </div>
        </div>
    <?php } ?>
    <div id="item">
        <table id="tabs">
            <td style="padding: 0 5px; width: 25%">
                <div id="content">
                    <div id="item">
                        <span class="title">Земледелие</span>
                    </div>
                </div>
            </td>
            <td style="padding: 0 5px; width: 25%">
                <a id="content" href="<?php echo new \core\Url(null, ['type' => 'animals']) ?>">
                    <div id="item">
                        <span class="title">Животноводство</span>
                    </div>
                </a>
            </td>
        </table>
        <div id="listing">
            <?php for ($i = 0; $i < $pagination->getCountItemsOnPage(); $i++) { ?>
                <?php $data = array_shift($seeds); ?>
                <?php if ($data) { ?>
                    <?php $seed = Core::findSeed($data['seed_id']) ?>
                    <?php $item = Core::findItem($seed->item_id) ?>

                    <a id="content" href="<?= new \core\Url('/farm/seed/pick', ['id' => $data['id']]) ?>">
                        <table>
                            <td>
                                <div id="item">
                                    <span class="image shadow">
                                        <img style="width: 40px;" src="/public/images/items/<?php echo $seed->icon ?>">
                                        <?php if ($seed->item_count > 1) { ?>
                                            <div class="count"><?php echo $seed->item_count ?></div>
                                        <?php } ?>
                                    </span>
                                </div>
                            </td>
                            <td style="width: 100%">
                                <div id="item">
                                    <?php echo ($seed->item_count > 1 ? '[x' . $seed->item_count . '] ' : null) . $seed->title ?>
                                </div>
                                <div id="item">
                                    <?php if($data['time_end'] > time()) { ?>
                                        <span>Осталось: <?= when($data['time_end']) ?></span>
                                    <?php } else { ?>
                                        <span class="time">Зерно готово!</span>
                                    <?php } ?>
                                </div>
                            </td>
                        </table>
                    </a>
                <?php } else { ?>
                    <div id="content">
                        <table>
                            <td>
                                <div id="item">
                                    <span class="image shadow">
                                        <img style="width: 40px;" src="/public/images/not_slot.png">
                                    </span>
                                </div>
                            </td>
                            <td style="width: 100%">
                                <div id="item">
                                    Земля, готовая к посеву
                                </div>
                            </td>
                        </table>
                    </div>
                <?php } ?>
            <?php } ?>
        </div>
        <?php
        if($pagination->getCountPages() > 1) {
            echo $pagination;
        }
        ?>
    </div>
    <?php if ($is_add) { ?>
        <div id="item">
            <a type="button" href="/farm/seeds">Посадить семя</a>
        </div>
    <?php } ?>
</div>
