<?php
/**
 * @var ui\Page $page
 * @var ui\Breadcrumbs $breadcrumbs
 */

$count_seeds = User::getAccount()->getFarm()->getCountSeeds();
$slot_seeds = 5 * \User::getAccount()->getExpProgress()->getLevel();

if ($count_seeds < $slot_seeds) {
    /** @var \PDO $connection */
    $connection = \Registry::get('connection');

    $res = $connection->query("SELECT id, id, profession_id, title, icon, item_id, item_count, time_life FROM `seeds` ");
    $seeds = $res->fetchAll(\PDO::FETCH_UNIQUE | \PDO::FETCH_CLASS, \data\Seed::class);

    $page = Registry::get('page');
    if ($breadcrumbs = $page->findLink('ui\Breadcrumbs_1')) {
        $breadcrumbs->addBreadcrumb(new \core\Url('/farm', ['type' => 'seeds']), 'Ферма');
        $breadcrumbs->addBreadcrumb(null, 'Посадить семя');
    }

    $view->assign('seeds', $seeds);
    return $view->render('seeds');
}

$redirect = new core\response\Redirect();
$redirect->setUrl(new \core\Url('/farm', ['type' => 'seeds']));
$redirect->send();