<?php
if (!$data = User::getAccount()->getFarm()->findSeed(filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT))) {
    $redirect = new core\response\Redirect();
    $redirect->setUrl((new \core\Url('/', ['type' => 'seeds'])));
    return $redirect;
}

if (!$seed = Core::findSeed($data['seed_id'])) {
    $redirect = new core\response\Redirect();
    $redirect->setUrl((new \core\Url('/', ['type' => 'seeds'])));
    return $redirect;
}

if (!($data['time_end'] > time())) {
    $result_items = $seed->getResultItems();
    if (!\User::getAccount()->getInventory()->addItem(...$result_items)) {
        \Flash::addMessageError('Не хватает место в инвентаре');
    } else {
        if (!$account_profession = User::getAccount()->getEvent()->findProfession($seed->profession_id)) {
            $account_profession = User::getAccount()->getEvent()->addProfession($seed->profession_id);
        }

        /** @var \PDO $connection */
        $connection = \Registry::get('connection');

        $percent = 20;
        $exp = $seed->energy * $percent / 100;

        $account_profession->exp += $seed->energy;
        User::getAccount()->exp += $exp;
        User::getAccount()->craft_reputation += $exp;

        $res = $connection->prepare("DELETE FROM `account_seeds` WHERE account_id = ? AND id = ? LIMIT 1");
        $res->execute([User::getAccount()->id, $data['id']]);

        foreach ($result_items AS $result_data) {
            $result_item = Core::findItem($result_data['item_id']);
            $table = new ui\Table();
            $table->addUiTd()->addUiItem()->addItem(new Ui\Image([
                'path' => '/public/images/items/' . $result_item->icon,
                'count' => $result_data['count']
            ]));
            $td = $table->addUiTd()->setStyle('width: 100%');
            $td->addUiItem()->setItems([
                ($result_data['count'] > 1 ? '[x' . $result_data['count'] . '] ' : null) . $result_item->title
            ]);
            $td->addUiItem()->setItems([
                'Предмет получено'
            ]);
            \Flash::addMessageSuccess($table);
        }

        $redirect = new core\response\Redirect();
        $redirect->setUrl((new \core\Url('/farm', ['type' => 'crops'])));
        return $redirect;
    }
}

$redirect = new core\response\Redirect();
$redirect->setUrl((new \core\Url('/farm/seed', ['id' => $data['id']])));
return $redirect;
