<?php
/**
 * @var ui\Page $page
 * @var ui\Breadcrumbs $breadcrumbs
 */

if (!$data = User::getAccount()->getFarm()->findSeed(filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT))) {
    $redirect = new core\response\Redirect();
    $redirect->setUrl((new \core\Url('/', ['type' => 'seeds'])));
    return $redirect;
}

if (!$seed = Core::findSeed($data['seed_id'])) {
    $redirect = new core\response\Redirect();
    $redirect->setUrl((new \core\Url('/', ['type' => 'seeds'])));
    return $redirect;
}

$page = Registry::get('page');
if ($breadcrumbs = $page->findLink('ui\Breadcrumbs_1')) {
    $breadcrumbs->addBreadcrumb(null, 'Животные');
}

$messages = Flash::getMessages();
$view->assign('messages', $messages);
$view->assign('data', $data);
$view->assign('seed', $seed);
$view->assign('is_pick', !($data['time_end'] > time()));
return $view->render('seed');