<?php
/**
 * @var ui\Page $page
 * @var ui\Breadcrumbs $breadcrumbs
 */

$count_seeds = User::getAccount()->getFarm()->getCountSeeds();
$slot_seeds = 5 * \User::getAccount()->getExpProgress()->getLevel();

if ($count_seeds < $slot_seeds) {
    if (!$seed = Core::findSeed(filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT))) {
        $redirect = new core\response\Redirect();
        $redirect->setUrl((new \core\Url('/', ['type' => 'seeds'])));
        return $redirect;
    }

    if (!$account_profession = User::getAccount()->getEvent()->findProfession($seed->profession_id)) {
        $account_profession = User::getAccount()->getEvent()->addProfession($seed->profession_id);
    }

    if(!$item = Core::findItem($seed->item_id)) {
        $redirect = new core\response\Redirect();
        $redirect->setUrl((new \core\Url('/', ['type' => 'seeds'])));
        return $redirect;
    }

    if ($request->isMethodPost()) {
            if ($account_profession->exp < $seed->exp) {
                Flash::addMessageError('Недостаточно мастерство');
            } else if (User::getAccount()->energy < $seed->energy) {
                Flash::addMessageError('Недостаточно энергии');
            } else if (!\User::getAccount()->getInventory()->deleteItem(['item_id' => $seed->item_id, 'count' => $seed->item_count,])) {
                \Flash::addMessageError('Не хватает ресурсов');
            } else {
                User::getAccount()->energy -= $seed->energy;

                /** @var \PDO $connection */
                $connection = \Registry::get('connection');

                $res = $connection->prepare("INSERT INTO `account_seeds` 
        (`account_id`, `seed_id`, `time_end`) VALUES (?, ?, ?)");
                $res->execute([User::getAccount()->id, $seed->id, time() + $seed->time_life]);
                \Flash::addMessageSuccess(new Ui\Item([
                    'items' => [
                        sprintf('Семя "%s" успешно посажено', $seed->title)
                    ]
                ]));

                $redirect = new core\response\Redirect();
                $redirect->setUrl((new \core\Url('/farm', ['type' => 'crops'])));
                return $redirect;
            }

            $redirect = new core\response\Redirect();
            $redirect->setUrl((new \core\Url('/farm/seed/add', [
                'id' => $seed->id,
            ])));
            return $redirect;
    }

    $page = Registry::get('page');
    if ($breadcrumbs = $page->findLink('ui\Breadcrumbs_1')) {
        $breadcrumbs->addBreadcrumb(null, 'Животные');
    }

    $messages = Flash::getMessages();
    $view->assign('messages', $messages);
    $view->assign('account_profession', $account_profession);
    $view->assign('seed', $seed);
    $view->assign('item', $item);
    $view->assign('is_add', $count_seeds < $slot_seeds);
    return $view->render('seed.add');
}

$redirect = new core\response\Redirect();
$redirect->setUrl((new \core\Url('/', ['type' => 'seeds'])));
$redirect->send();