<?php
/**
 * @var array $task
 * @var \data\Recipe $recipe
 * @var bool $is_pick
 * @var array $messages
 */
?>
<div id="content">
    <?php foreach ($messages AS $message) { ?>
        <div id="item">
            <div id="content" class="<?= $message['type'] ?>">
                <div id="item"><?= $message['text'] ?></div>
            </div>
        </div>
    <?php } ?>
    <div id="item">
        <div id="listing">
            <div id="content">
                <table>
                    <tr>
                        <td>
                            <div id="item">
                                <span class="image shadow">
                                    <img style="width: 40px;" src="/public/images/items/<?php echo $recipe->icon ?>">
                                    <?php if ($recipe->item_count > 1) { ?>
                                        <div class="count"><?php echo $recipe->item_count ?></div>
                                    <?php } ?>
                                </span>
                            </div>
                        </td>
                        <td style="width: 100%">
                            <div id="item">
                                <?php echo ($recipe->item_count > 1 ? '[x' . $recipe->item_count . '] ' : null) . $recipe->title ?>
                            </div>
                            <div id="item">
                                <?php if (!$is_pick) { ?>
                                    <span>Осталось: <?= when($task['time_end']) ?></span>
                                <?php } else { ?>
                                    <span class="time">Задача завершена!</span>
                                <?php } ?>
                            </div>
                        </td>
                    </tr>
                </table>
            </div>
            <?php
            if ($result_items = $recipe->getResultItems()) {
                /** @var \PDO $connection */
                $connection = \Registry::get('connection');

                echo '<div id="content">';
                echo '<div id="item"><b>Результат работы</b></div>';
                echo '<table>';
                foreach ($result_items AS $data_item) {
                    $result_item = Core::findItem($data_item['item_id']);

                    echo '<tr>';
                    echo '<td>';
                    ?>
                    <div id="item">
                        <span class="image shadow">
                            <img style="width: 40px;" src="/public/images/items/<?php echo $result_item->icon ?>">
                            <?php if ($data_item['count'] > 1) { ?>
                                <div class="count"><?php echo $data_item['count'] ?></div>
                            <?php } ?>
                        </span>
                    </div>
                    <?php
                    echo '</td>';
                    echo '<td style="width: 100%">';
                    echo '<div id="item">';
                    echo $result_item->title;
                    echo '</div>';
                    echo '</td>';
                    echo '</tr>';
                }
                echo '</table>';
                echo '</div>';
            }
            ?>
        </div>
    </div>
    <?php if ($is_pick) { ?>
        <div id="item">
            <a type="button" href="<?= new \core\Url('/craft/task/pick', ['id' => $task['id']]) ?>">Получить</a>
        </div>
    <?php } ?>
</div>
