<?php
/**
 * @var \data\Item $item
 * @var \data\Recipe $recipe
 * @var \data\Profession $profession
 * @var \data\Account_Profession $account_profession
 * @var array $messages
 * @var array $doodad
 */
?>
<div id="content">
    <?php foreach ($messages AS $message) { ?>
        <div id="item">
            <div id="content" class="<?= $message['type'] ?>">
                <div id="item"><?= $message['text'] ?></div>
            </div>
        </div>
    <?php } ?>
    <div id="item">
        <div id="listing">
            <div id="content">
                <div id="item">
                    <?= $recipe->title ?>
                </div>
                <table>
                    <tr>
                        <td>
                            <div id="item">
                                <span class="image shadow">
                                    <img style="width: 40px;" src="/public/images/items/<?= $recipe->icon ?>">
                                </span>
                            </div>
                        </td>
                        <td style="width: 100%">
                            <div id="item">
                                <?php
                                if (User::getAccount()->energy < $recipe->energy) {
                                    echo '<div class="box red">Энергия: ' . $recipe->energy . '</div>';
                                } else {
                                    echo '<div class="box">Энергия: ' . $recipe->energy . '</div>';
                                }
                                ?>
                            </div>
                            <div id="item">
                                <?php
                                if ($account_profession->exp < $recipe->exp) {
                                    echo '<div class="box red">Профессия: ' . $profession->title . ' ' . ($recipe->exp ?? null) . '</div>';
                                } else {
                                    echo '<div class="box">Профессия: ' . $profession->title . ' ' . ($recipe->exp ?? null) . '</div>';
                                }
                                ?>
                            </div>
                            <?php if ($doodad) { ?>
                            <div id="item">
                                <b style="color: darkred">Станок: <?= $doodad['title'] ?></b>
                            </div>
                            <?php } ?>
                        </td>
                    </tr>
                </table>
            </div>
            <div id="content">
                <div id="item">
                    <?php echo sprintf('<span>Время выполнение задач: %s</span>',
                        when($recipe->life, true)
                    ) ?>
                </div>
            </div>
            <?php
            if ($require_items = $recipe->getRequiredItems()) {
                /** @var \PDO $connection */
                $connection = \Registry::get('connection');

                echo '<div id="content">';
                echo '<div id="item"><b>Необходимые материалы</b></div>';
                echo '<table>';
                foreach ($require_items AS $data_item) {
                    $require_item = Core::findItem($data_item['item_id']);

                    $res = $connection->prepare('SELECT SUM(count) AS all_count 
                      FROM inventory_items 
                      WHERE item_id = ? AND account_id = ? LIMIT 1');
                    $res->execute([$require_item->id, User::getAccount()->id]);

                    if (!$data = $res->fetch()) {
                        $data = [
                            'all_count' => 0
                        ];
                    }

                    $all_count = $data['all_count'] ?? 0;
                    $all_count = $all_count > $require_item->count ? $require_item->count : $all_count;

                    echo '<tr>';
                    echo '<td>';
                    ?>
                    <div id="item">
                                <span class="image shadow">
                                    <img style="width: 40px;" src="/public/images/items/<?php echo $require_item->icon ?>">
                                    <?php if ($data_item['count'] > 1) { ?>
                                        <div class="count"><?php echo $data_item['count'] ?></div>
                                    <?php } ?>
                                </span>
                    </div>
                    <?php
                    echo '</td>';
                    echo '<td style="width: 100%">';
                    echo '<div id="item">';
                    if ($all_count < $data_item['count']) {
                        echo $require_item->title . '<span class="title box red" style="float: right">' . $all_count . ' / ' . $data_item['count'] . '</span>';
                    } else {
                        echo $require_item->title . '<span class="title box green" style="float: right">' . $all_count . ' / ' . $data_item['count'] . '</span>';
                    }
                    echo '</div>';
                    echo '</td>';
                    echo '</tr>';
                }
                echo '</table>';
                echo '</div>';
            }

            if ($result_items = $recipe->getResultItems()) {
                /** @var \PDO $connection */
                $connection = \Registry::get('connection');

                echo '<div id="content">';
                echo '<div id="item"><b>Результат работы</b></div>';
                echo '<table>';
                foreach ($result_items AS $data_item) {
                    $result_item = Core::findItem($data_item['item_id']);

                    echo '<tr>';
                    echo '<td>';
                    ?>
                    <div id="item">
                        <span class="image shadow">
                            <img style="width: 40px;" src="/public/images/items/<?php echo $result_item->icon ?>">
                            <?php if ($data_item['count'] > 1) { ?>
                                <div class="count"><?php echo $data_item['count'] ?></div>
                            <?php } ?>
                        </span>
                    </div>
                    <?php
                    echo '</td>';
                    echo '<td style="width: 100%">';
                    echo '<div id="item">';
                    echo $result_item->title;
                    echo '</div>';
                    echo '</td>';
                    echo '</tr>';
                }
                echo '</table>';
                echo '</div>';
            }
            ?>
        </div>
    </div>
    <?php if ($craft_count_tasks < $slot_craft AND !$recipe->doodad_id) { ?>
        <form id="form" action="" method="post">
            <div id="item">
                <input type="submit" value="Создать">
            </div>
        </form>
    <?php } ?>
</div>
