<?php
/**
 * @var array $tasks
 * @var array $messages
 * @var \ui\Pagination $pagination
 * @var bool $is_add
 */
?>
<div id="content">
    <?php foreach ($messages AS $message) { ?>
        <div id="item">
            <div id="content" class="<?= $message['type'] ?>">
                <?= $message['text'] ?>
            </div>
        </div>
    <?php } ?>
    <div id="item">
        <table id="tabs">
            <tr>
                <td style="padding: 0 5px; width: 25%">
                    <div id="content">
                        <div id="item">
                            <span class="title">Задачи</span>
                        </div>
                    </div>
                </td>
                <td style="padding: 0 5px; width: 25%">
                    <a id="content" href="<?php echo new \core\Url(null, ['from' => 'professions']) ?>">
                        <div id="item">
                            <span class="title">Професии</span>
                        </div>
                    </a>
                </td>
            </tr>
        </table>
        <div id="listing">
            <?php for ($i = $pagination->_getOffsetStart(); $i < $pagination->_getOffsetEnd(); $i++) { ?>
                <?php $task = array_shift($tasks); ?>
                <?php if($task) { ?>
                    <?php $recipe = Core::findRecipe($task['recipe_id']) ?>
                    <a href="<?php echo new \core\Url('/craft/task/pick', ['id' => $task['id']]) ?>" id="content">
                        <table>
                            <td>
                                <div id="item">
                                    <span class="image shadow">
                                        <img style="width: 40px;" src="/public/images/items/<?= $recipe->icon ?>">
                                    </span>
                                </div>
                            </td>
                            <td style="width: 100%">
                                <div id="item">
                                    <?= $recipe->title ?>
                                </div>
                                <div id="item">
                                    <?php if($task['time_end'] > time()) { ?>
                                        <span>Осталось: <?= when($task['time_end']) ?></span>
                                    <?php } else { ?>
                                        <span class="time">Задача готово!</span>
                                    <?php } ?>
                                </div>
                            </td>
                        </table>
                    </a>
                <?php } else { ?>
                    <div id="content">
                        <table>
                            <td>
                                <div id="item">
                                    <span class="image shadow">
                                        <img style="width: 40px;" src="/public/images/not_slot.png">
                                    </span>
                                </div>
                            </td>
                            <td style="width: 100%">
                                <div id="item">
                                    Пустой задача
                                </div>
                            </td>
                        </table>
                    </div>
                <?php } ?>
            <?php } ?>
        </div>
        <?php
        if ($pagination->getCountPages() > 1) {
            echo $pagination;
        }
        ?>
    </div>
    <?php if ($is_add) { ?>
        <div id="item">
            <a href="/craft/add" type="submit" >Создать задачу</a>
        </div>
    <?php } ?>
</div>
