<?php
/**
 * @var \data\Profession[] $professions
 * @var array $messages
 */
?>
<div id="content">
    <?php foreach ($messages AS $message) { ?>
        <div id="item">
            <div id="content" class="<?= $message['type'] ?>">
                <div id="item"><?= $message['text'] ?></div>
            </div>
        </div>
    <?php } ?>
    <div id="item">
        <table id="tabs">
            <tr>
                <td style="padding: 0 5px; width: 25%">
                    <a id="content" href="<?php echo new \core\Url(null, ['from' => 'tasks']) ?>">
                        <div id="item">
                            <span class="title">Задачи</span>
                        </div>
                    </a>
                </td>
                <td style="padding: 0 5px; width: 25%">
                    <div id="content">
                        <div id="item">
                            <span class="title">Професии</span>
                        </div>
                    </div>
                </td>
            </tr>
        </table>
        <div id="listing">
            <?php if ($professions) { ?>
                <?php foreach ($professions AS $profession) { ?>
                    <?php
                    if (!$account_profession = User::getAccount()->getEvent()->findProfession($profession->id)) {
                        $account_profession = User::getAccount()->getEvent()->addProfession($profession->id);
                    }
                    ?>
                    <a href="<?php echo new \core\Url('/craft/profession', ['id' => $profession->id]) ?>" id="content">
                        <table>
                            <td>
                                <div id="item">
                                    <span class="image shadow">
                                        <img style="width: 52px;" src="/public/images/professions/<?php echo $profession->icon?>">
                                    </span>
                                </div>
                            </td>
                            <td style="width: 100%">
                                <div id="item">
                                    [ <?php echo $account_profession->getExpProgress()->getName() ?> ] <?php echo $profession->title ?>
                                </div>
                                <div id="item">
                                    <?php echo $account_profession->exp . ' / ' . $account_profession->getExpProgress()->getAllExp() ?>
                                </div>
                                <?php echo $account_profession->getExpProgress() ?>
                            </td>
                        </table>
                    </a>
                <?php } ?>
            <?php } else { ?>

            <?php } ?>
        </div>
        <?php
        if($pagination->getCountPages() > 1) {
            echo $pagination;
        }
        ?>
    </div>
</div>
