<?php

if (!$task = User::getAccount()->getCraft()->findTask(filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT))) {
    $redirect = new core\response\Redirect();
    $redirect->setUrl((new \core\Url('/craft', ['from' => 'tasks'])));
    return $redirect;
}

if (!$recipe = Core::findRecipe($task['recipe_id'])) {
    $redirect = new core\response\Redirect();
    $redirect->setUrl((new \core\Url('/craft', ['from' => 'tasks'])));
    return $redirect;
}

if (!($task['time_end'] > time())) {
    $result_items = $recipe->getResultItems();
    if (!\User::getAccount()->getInventory()->addItem(...$result_items)) {
        \Flash::addMessageError('Не хватает место в инвентаре');
    } else {
        if (!$account_profession = User::getAccount()->getEvent()->findProfession($recipe->profession_id)) {
            $account_profession = User::getAccount()->getEvent()->addProfession($recipe->profession_id);
        }

        /** @var \PDO $connection */
        $connection = \Registry::get('connection');

        $percent = 20;
        $exp = $recipe->energy * $percent / 100;

        $account_profession->exp += $recipe->energy;
        User::getAccount()->exp += $exp;
        User::getAccount()->craft_reputation += $exp;

        $res = $connection->prepare("DELETE FROM `craft_tasks`WHERE account_id = ? AND id = ? LIMIT 1");
        $res->execute([User::getAccount()->id, $task['id']]);

        foreach ($result_items AS $result_data) {
            $result_item = Core::findItem($result_data['item_id']);
            $table = new ui\Table();
            $table->addUiTd()->addUiItem()->addItem(new Ui\Image([
                'path' => '/public/images/items/' . $result_item->icon,
                'count' => $result_data['count']
            ]));
            $td = $table->addUiTd()->setStyle('width: 100%');
            $td->addUiItem()->setItems([
                ($result_data['count'] > 1 ? '[x' . $result_data['count'] . '] ' : null) . $result_item->title
            ]);
            $td->addUiItem()->setItems([
                'Предмет получено'
            ]);
            \Flash::addMessageSuccess($table);
        }

        $redirect = new core\response\Redirect();
        $redirect->setUrl((new \core\Url('/craft', ['from' => 'tasks'])));
        return $redirect;
    }
}

$redirect = new core\response\Redirect();
$redirect->setUrl((new \core\Url('/craft/task', ['id' => $task['id']])));
return $redirect;
