<?php
/**
 */

if (!$profession = Core::findProfession($request->get('profession', FILTER_SANITIZE_NUMBER_INT))) {
    $redirect = new core\response\Redirect();
    $redirect->setUrl((new \core\Url('/craft', ['from' => 'professions']))->removeParam('id'));
    return $redirect;
}
if (!$account_profession = User::getAccount()->getEvent()->findProfession($profession->id)) {
    $account_profession = User::getAccount()->getEvent()->addProfession($profession->id);
}

if(!$recipe = $profession->findRecipe($request->get('id', FILTER_SANITIZE_NUMBER_INT))) {
    $redirect = new core\response\Redirect();
    $redirect->setUrl((new \core\Url('/craft/profession', ['id' => $profession->id]))->removeParam('profession'));
    return $redirect;
}

$slot_craft = \User::getAccount()->slot_craft;
$craft_count_tasks = User::getAccount()->getCraft()->getCountTasks();
$craft_max_tasks =  max($slot_craft, $craft_count_tasks);

if ($request->isMethodPost()) {
    if ($craft_count_tasks < $slot_craft AND !$recipe->doodad_id) {
        if ($account_profession->exp < $recipe->exp) {
            Flash::addMessageError('Недостаточно мастерство');
        } else if (User::getAccount()->energy < $recipe->energy) {
            Flash::addMessageError('Недостаточно энергии');
        } else if (!\User::getAccount()->getInventory()->deleteItem(...$recipe->getRequiredItems())) {
            \Flash::addMessageError('Не хватает ресурсов');
        } else {
            $time_end = time() + $recipe->life;

            User::getAccount()->energy -= $recipe->energy;

            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("INSERT INTO `craft_tasks` 
        (`account_id`, `recipe_id`, `time_end`) VALUES (?, ?, ?)");
            $res->execute([User::getAccount()->id, $recipe->id, $time_end]);
            \Flash::addMessageSuccess(new Ui\Item([
                'items' => [
                    sprintf('Задача "%s" успешно создан', $recipe->title)
                ]
            ]));

            $redirect = new core\response\Redirect();
            $redirect->setUrl((new \core\Url('/craft', ['from' => 'tasks'])));
            return $redirect;
        }

        $redirect = new core\response\Redirect();
        $redirect->setUrl((new \core\Url('/craft/recipe', [
            'id' => $recipe->id,
            'profession' => $profession->id
        ])));
        return $redirect;
    }
}

/** @var \PDO $connection */
$connection = \Registry::get('connection');

$res = $connection->prepare("SELECT * FROM doodads WHERE id = ? LIMIT 1");
$res->execute([$recipe->doodad_id]);

$doodad = $res->fetch();

$messages = Flash::getMessages();
$view->assign('messages', $messages);
$view->assign('slot_craft', $slot_craft);
$view->assign('craft_count_tasks', $craft_count_tasks);
$view->assign('craft_max_tasks', $craft_max_tasks);
$view->assign('profession', $profession);
$view->assign('account_profession', $account_profession);
$view->assign('recipe', $recipe);
$view->assign('doodad', $doodad);
return $view->render('recipe');