<?php
/**
 * @var \core\Request $request
 * @var \core\View $view
 * @var \ui\Breadcrumbs $breadcrumbs
 */

if (!$profession = Core::findProfession($request->getUrl()->getParam('id', 0))) {
    $redirect = new core\response\Redirect();
    $redirect->setUrl((new \core\Url('/craft', ['from' => 'professions']))->removeParam('id'));
    return $redirect;
}
if (!$account_profession = User::getAccount()->getEvent()->findProfession($profession->id)) {
    $account_profession = User::getAccount()->getEvent()->addProfession($profession->id);
}

/**
 * @var ui\Page $page
 */
$page = Registry::get('page');
if ($breadcrumbs = $page->findLink('ui\Breadcrumbs_1')) {
    $breadcrumbs->addBreadcrumb(new \core\Url('/craft', [
        'from' => 'professions',
    ]), 'Ремесло');
    $breadcrumbs->addBreadcrumb(null, "Професия - {$profession->title}");
}

$pagination = new ui\Pagination();
$pagination->setCountAllItems($profession->getCountRecipes());
$recipes = $profession->getRecipes($pagination->_getMySqlLimit());

$view->assign('recipes', $recipes);
$view->assign('profession', $profession);
$view->assign('account_profession', $account_profession);
$view->assign('pagination', $pagination);
return $view->render('profession');