<?php
/**
 * @var \core\View $view
 * @var \PDO $connection
 */

if (!$data = User::getAccount()
    ->getCity()
    ->findBuilding((int) $request->get('id', FILTER_SANITIZE_NUMBER_INT))) {
    $redirect = new core\response\Redirect();
    $redirect->setUrl('/');
    return $redirect;
}

if (!$building = Core::findBuilding($data['building_id'])) {
    $redirect = new core\response\Redirect();
    $redirect->setUrl('/');
    return $redirect;
}

if (isset($_GET['npc'])) {
    if (!$data = User::getAccount()
        ->getCity()
        ->findNpc((int)$request->get('npc', FILTER_SANITIZE_NUMBER_INT), $data['id'])) {
        $redirect = new core\response\Redirect();
        $redirect->setUrl((new \core\Url(null))->removeParam('npc'));
        return $redirect;
    }

    if (!$npc = Core::findNpc($data['npc_id'])) {
        $redirect = new core\response\Redirect();
        $redirect->setUrl((new \core\Url(null))->removeParam('npc'));
        return $redirect;
    }

    if (isset($_GET['vendor'])) {
        if (!$data = $npc->findVendor((int)$request->get('vendor', FILTER_SANITIZE_NUMBER_INT))) {
            $redirect = new core\response\Redirect();
            $redirect->setUrl((new \core\Url(null))
                ->removeParam('vendor'));
            return $redirect;
        }

        if (!$vendor = Core::findVendor($data['vendor_id'])) {
            $redirect = new core\response\Redirect();
            $redirect->setUrl((new \core\Url(null))
                ->removeParam('vendor'));
            return $redirect;
        }

        if (isset($_GET['item'])) {
            if (!$data = $vendor->findItem((int)$request->get('item', FILTER_SANITIZE_NUMBER_INT))) {
                $redirect = new core\response\Redirect();
                $redirect->setUrl((new \core\Url(null))->removeParam('item'));
                return $redirect;
            }

            if (!$item = Core::findItem($data['item_id'])) {
                $redirect = new core\response\Redirect();
                $redirect->setUrl((new \core\Url(null))->removeParam('item'));
                return $redirect;
            }

            if ($request->isMethodPost()) {
                if ($item->buy > User::getAccount()->money) {
                    \Flash::addMessageError('Не хватает монет');
                } elseif(!User::getAccount()->getInventory()->addItem([
                    'item_id' => $item->id,
                    'count' => 1
                ])) {
                    \Flash::addMessageError('Нет место в инвентаре');
                } else {
                    \User::getAccount()->money -= $item->buy;
                    \Flash::addMessageSuccess(sprintf('Предмет "%s" куплен', $item->title));
                }

                $redirect = new core\response\Redirect();
                $redirect->setUrl(new \core\Url(null));
                return $redirect;
            }

            /**
             * @var ui\Page $page
             * @var ui\Breadcrumbs $breadcrumbs
             */
            $page = Registry::get('page');
            $page->setTitle($npc->title);
            if ($breadcrumbs = $page->findLink('ui\Breadcrumbs_1')) {
                $breadcrumbs->addBreadcrumb((new \core\Url(null))
                    ->removeParam('npc')
                    ->removeParam('vendor')
                    ->removeParam('item'), $building->title);
                $breadcrumbs->addBreadcrumb((new \core\Url(null))
                    ->removeParam('vendor')
                    ->removeParam('item'), $npc->title);
                $breadcrumbs->addBreadcrumb((new \core\Url(null))
                    ->removeParam('item'), $vendor->title);
                $breadcrumbs->addBreadcrumb(null, $item->title);
            }

            $view->assign('messages', Flash::getMessages());
            $view->assign('item', $item);
            return $view->render('npc.vendor.item');
        }

        /**
         * @var ui\Page $page
         * @var ui\Breadcrumbs $breadcrumbs
         */
        $page = Registry::get('page');
        $page->setTitle($npc->title);
        if ($breadcrumbs = $page->findLink('ui\Breadcrumbs_1')) {
            $breadcrumbs->addBreadcrumb((new \core\Url(null))
                ->removeParam('npc')
                ->removeParam('vendor'), $building->title);
            $breadcrumbs->addBreadcrumb((new \core\Url(null))
                ->removeParam('vendor'), $npc->title);
            $breadcrumbs->addBreadcrumb(null, $vendor->title);
        }

        $view->assign('vendor', $vendor);
        return $view->render('npc.vendor');
    }

    /**
     * @var ui\Page $page
     * @var ui\Breadcrumbs $breadcrumbs
     */
    $page = Registry::get('page');
    $page->setTitle($npc->title);
    if ($breadcrumbs = $page->findLink('ui\Breadcrumbs_1')) {
        $breadcrumbs->addBreadcrumb((new \core\Url(null))
            ->removeParam('npc'), $building->title);
        $breadcrumbs->addBreadcrumb(null, $npc->title);
    }

    $view->assign('vendors', $npc->getVendors());
    $view->assign('npc', $npc);
    return $view->render('npc');
}

/**
 * @var ui\Page $page
 * @var ui\Breadcrumbs $breadcrumbs
 */
$page = Registry::get('page');
$page->setTitle($building->title);
if ($breadcrumbs = $page->findLink('ui\Breadcrumbs_1')) {
    $breadcrumbs->addBreadcrumb(null, $building->title);
}

$content = null;
if ($building->name) {
    if (file_exists(dirname(__DIR__) . '/buildings/' . $building->name . '.php')) {
        ob_start();
        $access = require_once dirname(__DIR__) . '/buildings/' . $building->name . '.php';
        $content = ob_get_clean();
    }
}

$view->assign('access', $access);
$view->assign('content', $content);
$view->assign('npcs', User::getAccount()->getCity()->getNpcs($data['id']));
$view->assign('buildings', User::getAccount()->getCity()->getBuildings($data['id']));
$view->assign('building', $building);
return $view->render('building');