<?php

use package\Module;
use package\Theme;
use core\Response;

try {
    require_once(__DIR__ . '/engine/core.php');

    Registry::set('connection', function () {
        $pdo = new \PDO('mysql:host=localhost;dbname=magic_craft2', 'root', null, array(
            \PDO::ATTR_ERRMODE => \PDO::ERRMODE_EXCEPTION,
            \PDO::ATTR_DEFAULT_FETCH_MODE => \PDO::FETCH_ASSOC
        ));
        return $pdo;
    });
    Registry::set('module', function () {
        $module = new Module(__DIR__ . '/public/modules');
        return $module;
    });
    Registry::set('theme', function () {
        $theme = new Theme(__DIR__ . '/public/themes');
        return $theme;
    });
    Registry::set('page', function () {
        /**
         * @var \package\Theme $theme
         */
        $theme = Registry::get('theme');

        $page = new \ui\Page();
        $page->setStyles($theme->findResource($theme->getCurrentTheme(), 'css'));
        $page->setScripts($theme->findResource($theme->getCurrentTheme(), 'js'));

        $breadcrumbs = new \ui\Breadcrumbs();
        $breadcrumbs->setTitle(User::isAuth() ? 'Город' : 'Авторизация');
        $page->addLink($breadcrumbs);

        if(User::isAuth()) {
            $user_header = new \ui\User_Header();
            $page->addLink($user_header);

            $user_footer = new \ui\User_Footer();
            $page->addLink($user_footer);
        }

        $footer = new \ui\Footer();
        $page->addLink($footer);

        return $page;
    });
    $request = new \core\Request();

    try {
        /**
         * @var Module $module
         */
        $module = Registry::get('module');
        if (!$result = $module->execute($request)){
            $view = new \core\View(__DIR__ . '/public/views');

            $result['title'] = 'Страница не найдено';
            $result['content'] = $view->render('error_404');

            /**
             * @var ui\Page $page
             * @var ui\Breadcrumbs $breadcrumbs
             */
            $page = Registry::get('page');
            $breadcrumbs = $page->findLink('ui\Breadcrumbs_1');
            $breadcrumbs->addBreadcrumb(null, 'Страница не найдено');
        }

        if ($result['content'] instanceof Response\Redirect) {
            $result['content']->send();
        }
    } catch (Exception $e) {
        $view = new \core\View(__DIR__ . '/public/views');
        $view->assign('message', $e->getMessage() . PHP_EOL . $e->getTraceAsString());

        /**
         * @var ui\Page $page
         */
        $page = Registry::get('page');
        $page->setTitle('Внутренняя ошибка сервера');
        $page->addItem($view->render('error_500'));

        $response = new Response\Html();
        $response->setStatus(500);
        $response->setContent((string) $page);
        $result = $response;
    }

    if (!$result instanceof Response) {
        /**
         * @var ui\Page $page
         */
        $page = Registry::get('page');
        if(isset($result['title'])) {
            $page->setTitle($result['title']);
        }

        if(isset($result['content'])) {
            $page->addItem($result['content']);
        }

        $response = new Response\Html();
        $response->setContent((string) $page);
        $result = $response;
    }
    if (strpos($result->getContent(), '{exec_time}') !== false OR strpos($result->getContent(), '{mem_usage}') !== false)
    {
        $total = Profiler::getTotal();
        $result->setContent(str_replace(
            array('{exec_time}', '{mem_usage}'),
            array(round($total[0], 4), round($total[1] / pow(1024, 2), 3)),
            $result->getContent()
        ));
    }
    $result->send();
} catch (Exception $e) {
    // если падает не в модуле
    http_response_code(500);
    header("Content-Type: text/plain");
    echo $e->getMessage() . PHP_EOL;
    echo $e->getTraceAsString();
}