<?php

ini_set('error_reporting', E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

define('DIR_HOME', dirname(__DIR__));
defined('CORE_START_TIME') or define('CORE_START_TIME', microtime(true));
defined('CORE_START_MEMORY') or define('CORE_START_MEMORY', memory_get_usage());

spl_autoload_register(function (string $name) {
    $file_path = '/classes/' . $name . '.php';
    if (!file_exists(DIR_HOME . '/engine' . $file_path)) {
        return;
    }

    require_once DIR_HOME . '/engine' . $file_path;
});

function memory(int $size) {
    $name = 'байт';

    if ($size >= 1024) {
        $size = round($size / 1024, 2);
        $name = 'кб';
    }

    if ($size >= 1024) {
        $size = round($size / 1024, 2);
        $name = 'мб';
    }

    if ($size >= 1024) {
        $size = round($size / 1024, 2);
        $name = 'гб';
    }

    if ($size >= 1024) {
        $size = round($size / 1024, 2);
        $name = 'тб';
    }

    if ($size >= 1024) {
        $size = round($size / 1024, 2);
        $name = 'пб';
    }

    return sprintf('%d %s', $size, $name);
}
function generator($len = 32)
{
    $generator = '';
    $small = 'abcdefghijklmnopqrstuvwxyz';
    $large = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $numbers = '1234567890';
    for ($i = 0; $i < $len; $i++) {
        switch (mt_rand(1, 3)) {
            case 3 :
                $generator .= $large [mt_rand(0, 25)];
                break;
            case 2 :
                $generator .= $small [mt_rand(0, 25)];
                break;
            case 1 :
                $generator .= $numbers [mt_rand(0, 9)];
                break;
        }
    }
    return $generator;
}
function number($num, $one, $two, $more)
{
    $num = (int)$num;
    $l2 = substr($num, strlen($num) - 2, 2);

    if ($l2 >= 5 && $l2 <= 20)
        return $more;
    $l = substr($num, strlen($num) - 1, 1);
    switch ($l) {
        case 1:
            return $one;
            break;
        case 2:
            return $two;
            break;
        case 3:
            return $two;
            break;
        case 4:
            return $two;
            break;
        default:
            return $more;
            break;
    }
}
function when($time = null, $life = false, $adaptive = true)
{
    if ($life OR $time > time()) {
        if (!$life) {
            $time -= time();
        }

        $mes = 0;
        $day = 0;
        $hour = 0;
        $min = 0;
        $sec = 0;

        if ($time) {
            $sec = $time % 60;
        }
        if ($time >= 60) {
            $min = floor($time / 60 % 60);
        }
        if ($time >= 3600) {
            $hour = floor($time / 3600 % 24);
        }
        if ($time >= 86400) {
            $day = floor($time / 86400 % 30);
        }
        if ($time >= 2592000) {
            $mes = floor($time / 2592000 % 12);
        }

        if ($mes) {
            return $mes . ' месяц' . number($mes, '', 'а', 'ев') . ($day ? (', ' . $day . ' ' . number($day, 'день', 'дня', 'дней') . ($hour ? ' и ' . $hour . ' час' . number($hour, '', 'а', 'ов') : '')) : '');
        }
        if ($day) {
            return $day . ' ' . number($day, 'день', 'дня', 'дней') . ($hour ? (', ' . $hour . ' час' . number($hour, '', 'а', 'ов') . ($min ? ' и ' . $min . ' минут' . number($min, 'а', 'ы', '') : '')) : '');
        }
        if ($hour) {
            return $hour . ' час' . number($hour, '', 'а', 'ов') . ($min ? (', ' . $min . ' минут' . number($min, 'а', 'ы', '') . ($sec ? ' и ' . $sec . ' секунд' . number($sec, 'а', 'ы', '') : '')) : '');
        }
        if ($min) {
            return $min . ' минут' . number($min, 'а', 'ы', '') . ($sec ? ' и ' . $sec . ' секунд' . number($sec, 'а', 'ы', '') : '');
        }
        return $sec . ' секунд' . number($sec, 'а', 'ы', '');
    } else {
        if (!$time) {
            $time = time();
        }

        $time_shift = 0;
        $time = $time + $time_shift * 3600;
        $export = date('j M Y в H:i', $time);
        $time_p[0] = date('j n Y', $time);
        $time_p[1] = date('H:i', $time);
        if ($adaptive && $time_p[0] == date('j n Y', time() + $time_shift * 60 * 60)) {
            $export = date('H:i:s', $time);
        }
        if ($adaptive && $time_p[0] == date('j n Y', time() - 60 * 60 * (24 - $time_shift))) {
            $export = sprintf("Вчера в %s", $time_p[1]);
        }
        $export = str_replace('Jan', 'Янв', $export);
        $export = str_replace('Feb', 'Фев', $export);
        $export = str_replace('Mar', 'Марта', $export);
        $export = str_replace('May', 'Мая', $export);
        $export = str_replace('Apr', 'Апр', $export);
        $export = str_replace('Jun', 'Июня', $export);
        $export = str_replace('Jul', 'Июля', $export);
        $export = str_replace('Aug', 'Авг', $export);
        $export = str_replace('Sep', 'Сент', $export);
        $export = str_replace('Oct', 'Окт', $export);
        $export = str_replace('Nov', 'Ноября', $export);
        $export = str_replace('Dec', 'Дек', $export);
        return $export;
    }
}

session_start() or die('Невозможно инициализировать сессии');