<?php

abstract class User
{
    protected static $account;

    /**
     * @return \data\Account
     * @throws Exception
     */
    public static function getAccount()
    {
        if (!self::$account) {
            self::$account = Core::findAccount(self::getAuthID());
        }
        return self::$account;
    }

    /**
     * @return bool
     * @throws Exception
     */
    public static function isAuth()
    {
        if(!$account = self::getAccount()) {
            return false;
        }

        return true;
    }

    /**
     * @return int
     * @throws Exception
     */
    public static function getAuthID() {
        if(isset($_SESSION['auth_token'])) {
            /** @var \PDO $connection */
            $connection = Registry::get('connection');

            $res = $connection->prepare("SELECT * FROM auth_accounts WHERE token = ? LIMIT 1");
            $res->execute([$_SESSION['auth_token']]);

            if(!$data = $res->fetch()) {
                unset($_SESSION['auth_token']);
                return false;
            }

            $token = md5(generator());
            $_SESSION['auth_token'] = $token;

            $res = $connection->prepare("UPDATE auth_accounts SET token = ?, time = ? WHERE account_id = ?");
            $res->execute([$token, time(), $data['account_id']]);

            return $data['account_id'];
        }

        return false;
    }

    /**
     * @param $account_id
     * @return string
     * @throws Exception
     */
    public static function generateAuthToken($account_id) {
        /** @var \PDO $connection */
        $connection = Registry::get('connection');

        $res = $connection->prepare("SELECT * FROM auth_accounts WHERE account_id = ? LIMIT 1");
        $res->execute([$account_id]);

        if (!$data = $res->fetch()) {
            $token = md5($account_id . generator());
            $res = $connection->prepare("INSERT INTO auth_accounts 
            (account_id, token, time) VALUES (?, ?, ?)");
            $res->execute([$account_id, $token, time()]);
            return $token;
        }

        $token = md5($account_id . generator());

        $res = $connection->prepare("UPDATE auth_accounts SET token = ?, time = ? WHERE account_id = ?");
        $res->execute([$token, time(), $account_id]);

        return $token;
    }
}