<?php

namespace ui;

use Ui;

class User_Footer extends \Ui
{
    protected $__menus = [];

    /**
     * @return array
     */
    public function getMenus(): array
    {
        return $this->__menus;
    }

    /**
     * @param $url
     * @param $icon
     * @param $title
     * @param int $count
     */
    public function addMenu($url, $icon, $title, $count = 0)
    {
        $this->__menus[] = [
            'url' => $url,
            'icon' => $icon,
            'title' => $title,
            'count' => $count
        ];
    }

    /**
     * @param Ui $ui
     * @return bool
     */
    protected function onAddedItem(Ui $ui)
    {
        return false;
    }

    /**
     * @param Ui $ui
     * @return bool
     */
    protected function onLinked(Ui $ui)
    {
        if($ui instanceof Page) {
            return true;
        }
        return false;
    }
}