<?php

namespace ui\progress;

use data\Account;
use Ui;

class Energy extends \Ui
{
    protected $current_energy = 0;
    protected $max_energy = 0;
    protected $percent_energy = 0;

    /**
     * Energy constructor.
     * @param Account $account
     * @param array $levels
     */
    function __construct(Account $account, array $levels)
    {
        parent::__construct();
        // Энергия
        $current_energy = $account->energy;
        $max_energy = 0;

        // Процент энергия
        $percent_energy = 0;

        foreach ($levels AS $level => $add_energy) {
            if ($account->getExpProgress()->getLevel() < $level) {
                break;
            }

            $max_energy = $add_energy;
            $percent_energy = $current_energy * 100 / $max_energy;
        }

        // Сохранить энергии
        $this->current_energy = $current_energy;
        $this->max_energy = $max_energy;

        // Сохранить процент энергии
        $this->percent_energy = min(max(0, $percent_energy), 100);
    }

    /**
     * @return int
     */
    public function getEnergy()
    {
        return (int)$this->current_energy;
    }

    /**
     * @return int
     */
    public function getMaxEnergy()
    {
        return (int)$this->max_energy;
    }

    /**
     * @return int
     */
    public function getPercentEnergy()
    {
        return (int)$this->percent_energy;
    }

    /**
     * @param \Ui $ui
     * @return bool
     */
    protected function onLinked(\Ui $ui)
    {
        return false;
    }

    /**
     * @param Ui $ui
     * @return bool
     */
    protected function onAddedItem(Ui $ui)
    {
        // TODO: Implement onAddedItem() method.
    }
}