<?php

namespace ui;

use Ui;

class Progress extends \Ui
{
    protected $current_level = 1;
    protected $max_level = 1;
    protected $current_exp = 0;
    protected $max_exp = 0;
    protected $percent_exp = 0;
    protected $all_exp = 0;

    /**
     * Progress constructor.
     * @param int $exp
     * @param array $levels
     */
    function __construct($exp, array $levels)
    {
        parent::__construct();

        // Общий опыт
        $all_exp = 0;

        // Опыт
        $current_exp = 0;
        $max_exp = 0;

        // Уровень
        $current_level = 1;
        $max_level = max(array_keys($levels));

        // Процент опыта
        $percent_exp = 0;

        foreach ($levels AS $level => $add_exp) {
            if ($exp < $all_exp) {
                break;
            }

            $current_level = $level;
            $current_exp = min($exp - $all_exp, $add_exp);
            $max_exp = $add_exp;

            $all_exp += $add_exp;
            $percent_exp = $current_exp * 100 / $max_exp;
        }

        // Сохранить опыт
        $this->current_exp = $current_exp;
        $this->max_exp = $max_exp;
        $this->all_exp = $all_exp;

        // Сохранить уровень
        $this->current_level = $current_level;
        $this->max_level = $max_level;

        // Сохранить процент опыта
        $this->percent_exp = min(max(0, $percent_exp), 100);
    }

    public function getLevel()
    {
        return (int)$this->current_level;
    }

    public function getMaxLevel()
    {
        return (int)$this->max_level;
    }

    public function getExp()
    {
        return (int)$this->current_exp;
    }

    public function getMaxExp()
    {
        return (int)$this->max_exp;
    }

    public function getPercentExp()
    {
        return (int)$this->percent_exp;
    }

    public function getName() {
        if($this->getLevel()) {
            return $this->getLevel() . ' уровень';
        }

        return 'Новичок';
    }

    /**
     * @return int
     */
    public function getAllExp(): int
    {
        return $this->all_exp;
    }

    /**
     * @param Ui $ui
     * @return bool
     */
    protected function onLinked(Ui $ui)
    {
        return false;
    }

    /**
     * @param Ui $ui
     * @return bool
     */
    protected function onAddedItem(Ui $ui)
    {
        return false;
    }
}