<?php

namespace ui;

use core\Url;

class Pagination extends \Ui
{
    protected
        $_count_items_on_page = 5,
        $_count_pages = 1,
        $_url_page_param = 'page',
        $_count_all_items = 0,
        $_current_page = 1,
        $_show_if_one_page = false;

    public function _getOffsetStart()
    {
        return $this->getCountItemsOnPage() * ($this->getCurrentPage() - 1);
    }

    public function _getOffsetEnd()
    {
        return $this->getCountItemsOnPage() * $this->getCurrentPage();
    }

    public function _getMySqlLimit()
    {
        return $this->_getOffsetStart() . ' , ' . $this->getCountItemsOnPage();
    }

    /**
     * Расчет текущей страницы
     * @param null|int $current_page
     */
    protected function _calc($current_page = null)
    {
        if (is_null($current_page)) {
            $current_page = (new Url())->getParam($this->_url_page_param);
        }

        if(!$this->_count_all_items OR !$this->_count_items_on_page) {
            $count_pages = 1;
        } else {
            $count_pages = ceil($this->_count_all_items / $this->_count_items_on_page);
        }

        if ($current_page === 'last') {
            $current_page = $count_pages;
        }

        $current_page = (int)$current_page;

        $current_page = $current_page > $count_pages ? $count_pages : $current_page;
        $current_page = $current_page < 1 ? 1 : $current_page;

        $this->_count_pages = $count_pages;
        $this->_current_page = $current_page;
    }

    /**
     * Кол-во пунктов на страницу
     * @return int
     */
    public function getCountItemsOnPage()
    {
        return $this->_count_items_on_page;
    }

    /**
     * Кол-во пунктов на страницу
     * @param int $count_items_on_page
     */
    public function setCountItemsOnPage($count_items_on_page)
    {
        $this->_count_items_on_page = $count_items_on_page;
        $this->_calc();
    }

    /**
     * GET параметр, из которого берем текущую страницу
     * @return string
     */
    public function getUrlPageParam()
    {
        return $this->_url_page_param;
    }

    /**
     * GET параметр, из которого берем текущую страницу
     * @param string $url_page_param
     */
    public function setUrlPageParam($url_page_param)
    {
        $this->_url_page_param = $url_page_param;
        $this->_calc($url_page_param);
    }

    /**
     * Количество пунктов всего
     * @return int
     */
    public function getCountAllItems()
    {
        return $this->_count_all_items;
    }

    /**
     * Количество пунктов всего
     * @param int $count_all_items
     */
    public function setCountAllItems($count_all_items)
    {
        $this->_count_all_items = $count_all_items;
        $this->_calc();
    }

    /**
     * Отображение списка страниц, если всего одна страница
     * @return boolean
     */
    public function getShowIfOnePage()
    {
        return $this->_show_if_one_page;
    }

    /**
     * Отображение списка страниц, если всего одна страница
     * @param boolean $show_if_one_page
     */
    public function setShowIfOnePage($show_if_one_page)
    {
        $this->_show_if_one_page = $show_if_one_page;
    }

    /**
     * Номер текущей страницы
     * @return int
     */
    public function getCurrentPage()
    {
        return $this->_current_page;
    }

    /**
     * @return int
     */
    public function getCountPages(): int
    {
        return $this->_count_pages;
    }

    /**
     * @param \Ui $ui
     * @return bool
     */
    protected function onAddedItem(\Ui $ui)
    {
        return false;
    }

    /**
     * @param \Ui $ui
     * @return bool
     */
    protected function onLinked(\Ui $ui)
    {
        return false;
    }
}