<?php

namespace ui;

use Ui;

class Money extends \Ui
{
    protected $gold = 0;
    protected $silver = 0;
    protected $bronze = 0;

    /**
     * Money constructor.
     * @param int $money
     */
    function __construct($money)
    {
        parent::__construct();
        $this->gold = (int)($money / 10000);
        $this->silver = (int)(($money - $this->gold * 10000) / 100);
        $this->bronze = (int)($money - $this->gold * 10000) - ($this->silver * 100);
    }

    /**
     * @return int
     */
    public function getGold()
    {
        return (int)$this->gold;
    }

    /**
     * @return int
     */
    public function getSilver()
    {
        return (int)$this->silver;
    }

    /**
     * @return int
     */
    public function getBronze()
    {
        return (int)$this->bronze;
    }

    /**
     * @param Ui $ui
     * @return bool
     */
    protected function onLinked(Ui $ui)
    {
        return false;
    }

    /**
     * @param Ui $ui
     * @return bool
     */
    protected function onAddedItem(Ui $ui)
    {
        return false;
    }
}