<?php

namespace ui;

use Ui;

class Breadcrumbs extends \Ui
{
    protected $__breadcrumbs = [];
    protected $__title;
    protected $__icon;

    /**
     * @return array
     */
    public function getBreadcrumbs(): array
    {
        return $this->__breadcrumbs;
    }

    /**
     * @param $url
     * @param $title
     */
    public function addBreadcrumb($url, $title) {
        $this->__breadcrumbs[] = [
            'url' => $url,
            'title' => $title
        ];
    }

    /**
     * @return mixed
     */
    public function getTitle()
    {
        return $this->__title;
    }

    /**
     * @param mixed $_title
     */
    public function setTitle($_title)
    {
        $this->__title = $_title;
    }

    /**
     * @return mixed
     */
    public function getIcon()
    {
        return $this->__icon;
    }

    /**
     * @param mixed $_icon
     */
    public function setIcon($_icon)
    {
        $this->__icon = $_icon;
    }

    /**
     * @param Ui $ui
     * @return bool
     */
    protected function onAddedItem(Ui $ui)
    {
        return false;
    }

    /**
     * @param Ui $ui
     * @return bool
     */
    protected function onLinked(Ui $ui)
    {
        if ($ui instanceof Page) {
            return true;
        }
        return false;
    }
}