<?php

abstract class Ui extends Configurator
{
    protected $__items = [];
    protected $__links = [];

    public function setItems($items)
    {
        $this->__items = [];
        foreach ($items AS $item) {
            $this->addItem($item);
        }
        return $this;
    }

    /**
     * @return array
     */
    public function getItems(): array
    {
        return $this->__items;
    }

    /**
     * @param $item
     */
    public function addItem($item) {
        if($item instanceof Ui) {
            if ($item->onAddedItem($this)) {
                $this->__items[$item->getID()] = $item;
            }
        }

        if (is_string($item)) {
            $this->__items[] = $item;
        }
    }

    /**
     * @param $ui
     */
    public function addLink(Ui $ui)
    {
        if ($ui->onLinked($this)) {
            $this->__links[$ui->getID()] = $ui;
        }
    }

    /**
     * @param $name
     * @return bool
     */
    public function findLink($name) {
        if (isset($this->__links[$name])) {
            return $this->__links[$name];
        }
        return false;
    }

    /**
     * @return ui\Item
     */
    public function addUiItem()
    {
        return $this->__items[] = new Ui\Item();
    }

    /**
     * @param Ui $ui
     * @return bool
     */
    protected abstract function onAddedItem(Ui $ui);

    /**
     * @param Ui $ui
     * @return bool
     */
    protected abstract function onLinked(Ui $ui);

    /**
     * @return string
     */
    public function __toString()
    {
        /**
         * @var \package\Theme $theme;
         */
        $theme = Registry::get('theme');
        return $theme->compileView($this);
    }
}