<?php

abstract class Text
{
    /**
     * Экранирование HTML при выводе.
     * Используется в основном для атрибутов HTML,
     * а также для экранирования всего, что только может вводиться вручную пользователем
     * @param string $string
     * @return string
     */
    public static function toValue($string)
    {
        return htmlspecialchars($string, ENT_QUOTES | ENT_HTML5, 'UTF-8', false);
    }

    /**
     * Форматирование текста перед выводом + экранирование HTML.
     * Используется для вывода комментов и другого содержимого.
     * @param string $string
     * @return string
     */
    public static function toOutput($string)
    {
        return self::toValue($string);
    }

    /**
     * @param string $string
     * @param bool $exception_is_empty бросать исключение, если строка пуста
     * @return string|null
     * @throws \Exception
     */
    public static function toSave($string, $exception_is_empty = true)
    {
        if (!is_scalar($string)) {
            throw new \Exception(sprintf('Ожидается скалярное значение'));
        }

        // явное приведение типа
        $string = (string)$string;

        // удаляем все управляющие символы
        $string = preg_replace('/\p{Cc}+/u', '', $string);
        // удаляем переносы вначале и конце строки
        $string = trim($string);

        if ($string === "") {
            $string = null;
        }

        if ($exception_is_empty && is_null($string)) {
            throw new \Exception(sprintf('Пустая строка'));
        }

        return $string;
    }
}