<?php

abstract class Registry
{
    protected static $containers = [];
    protected static $instances = [];

    /**
     * @param string $name
     * @param callable $component
     * @throws Exception
     */
    public static function set(string $name, callable $component)
    {
        if(isset(self::$containers[$name])) {
            throw new Exception();
        }

        self::$containers[$name] = $component;
    }

    /**
     * @param string $name
     * @return mixed
     * @throws Exception
     */
    public static function get(string $name)
    {
        if(!isset(self::$containers[$name])) {
            throw new Exception();
        }

        if (!isset(self::$instances[$name])) {
            return self::$instances[$name] = call_user_func(self::$containers[$name]);
        }

        return self::$instances[$name];
    }
}