<?php

namespace package;

use core\View;

class Theme extends \Package
{
    protected function onCheckComponent($component)
    {
        // TODO: Implement onCheckComponent() method.
    }
    protected function onUpdateComponent($component)
    {
        // TODO: Implement onUpdateComponent() method.
    }
    protected function onLoadComponent(\Component $component)
    {
    }

    protected function onUpdate()
    {
        // TODO: Implement onUpdate() method.
    }
    protected function onLoad()
    {
        // TODO: Implement onLoad() method.
    }

    protected function getType()
    {
        return 'theme';
    }
    protected function getClass()
    {
        return \component\Theme::class;
    }

    /**
     * Theme constructor.
     * @param string $path_dir
     */
    public function __construct(string $path_dir)
    {
        $this->__types = array_merge($this->__types, ['resources']);
        parent::__construct($path_dir);
    }

    /**
     * Возвращает тему оформления по-умолчанию.
     * Берется первая попавшаяся активная тема оформления
     * @return string
     */
    private function _getDefaultTheme()
    {
        $components = $this->getComponents();
        foreach ($components AS $component) {
            if ($component->isEnabled()) {
                return $component->getName();
            }
        }
        return $components[0]->getName();
    }

    /**
     * Возвращает текущую тему оформления
     * @return string
     * @throws \Exception
     */
    public function getCurrentTheme()
    {
        $current_theme = 'System';

        if (!$current_theme || !$this->hasComponent($current_theme) || !$this->getIsEnabled($current_theme)) {
            $current_theme = $this->_getDefaultTheme();
        }

        if (!$current_theme || !$this->hasComponent($current_theme) || !$this->getIsEnabled($current_theme)) {
            throw new \Exception("Не найдено ни одной активной темы оформления");
        }

        return $current_theme;
    }

    /**
     * @param $name
     * @param $type
     * @return array
     */
    public function findResource($name, $type)
    {
        $component = $this->findComponent($name);
        $resources = $component->findConfig('resources');

        if (!$resources OR !array_key_exists($type, $resources)) {
            return [];
        }

        $all_files_rel_path = [];
        $patterns = (array) $resources[$type];
        foreach ($patterns AS $pattern) {
            $files_abs_path = (array)glob($this->__path_dir . '/' . $name . '/' . $pattern, GLOB_NOSORT);
            foreach ($files_abs_path AS $file_abs_path) {
                $all_files_rel_path[] = \File_System::getRelPath($file_abs_path);
            }
        }

        return array_unique($all_files_rel_path);
    }

    /**
     * @param \Ui $ui
     * @return string
     * @throws \Exception
     */
    public function compileView(\Ui $ui)
    {
        static $view;

        if(!$view) {
            $view = new View($this->__path_dir . '/' . $this->getCurrentTheme() . '/views');
        }

        $class = get_class($ui);
        $view->assign('ui', $ui);

        do {
            $class_name = strtolower((new \ReflectionClass($class))->getShortName());
            if ($result = $view->render($class_name)) {
                return $result;
            }
        } while ($class !== 'ui' && $class = get_parent_class($class));

        throw new \Exception(sprintf('Нет шаблона для отображения модели %s', $class_name));
    }
}