<?php

abstract class File_System
{
    public static function getSiteRelPath()
    {
        return self::getRelPath(DIR_HOME);
    }

    public static function getRelPath($abs_path)
    {
        return str_replace(self::getUnixPath($_SERVER['DOCUMENT_ROOT']), '', self::getUnixPath($abs_path));
    }

    public static function getAbsPath($rel_path)
    {
        if ($rel_path{0} !== '/' && $rel_path{0} !== '\\') {
            $rel_path = '/' . $rel_path;
        }

        return DIR_HOME . self::getSystemPath($rel_path);
    }

    public static function getUnixPath($path)
    {
        return str_replace('\\', '/', $path);
    }

    public static function getSystemPath($path)
    {
        return str_replace(array('\\', '/'), DIRECTORY_SEPARATOR, $path);
    }
}