<?php

namespace data;

/**
 * Class Building
 * @package data
 * @property string title
 * @property string name
 */
class Vendor extends \Data
{
    protected $title;
    protected $items = [];

    /**
     * @return array
     */
    public function getItems() {
        if (!$this->items) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare('SELECT id, id, vendor_id, item_id
            FROM `vendor_items` WHERE `vendor_id` = ?');
            $res->execute([$this->id]);

            $this->items = $res->fetchAll(\PDO::FETCH_UNIQUE);
        }

        return $this->items;
    }

    /**
     * @param int|null $id
     * @return array
     */
    public function findItem(int $id = null) {
        if(!isset($this->items[$id])) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("SELECT * FROM `vendor_items` 
            WHERE `id` = ? AND vendor_id = ? LIMIT 1");
            $res->execute([$id, $this->id]);
            $this->items[$id] = $res->fetch();
        }
        return $this->items[$id];
    }

    /**
     * @return string
     */
    public function getFromName()
    {
        return 'vendors';
    }
}