<?php

namespace data;

/**
 * Рецепт [recipe]
 * @property int profession_id
 * @property int item_id
 * @property int item_count
 * @property string title
 * @property string icon
 * @property int time_life
 * @property int energy
 * @property int exp
 */
class Seed extends \Data
{
    protected $item_id = 0;
    protected $exp = 0;
    protected $profession_id = 0;
    protected $item_count = 1;
    protected $time_life = 0;
    protected $energy = 0;
    protected $icon;
    protected $title;
    protected $result_items = [];

    /**
     * @return array
     */
    public function getResultItems()
    {
        if (!$this->result_items) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare('SELECT * FROM `seed_result_items` WHERE `seed_id` = ?');
            $res->execute([$this->id]);

            $this->result_items = $res->fetchAll();
        }

        return $this->result_items;
    }

    /**
     * @return string
     */
    public function getFromName()
    {
        return 'seeds';
    }
}